"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.paths = exports.SLOS_PAGE_LINK = exports.RULES_PAGE_LINK = exports.OBSERVABILITY_BASE_PATH = exports.ALERT_PAGE_LINK = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVABILITY_BASE_PATH = '/app/observability';
exports.OBSERVABILITY_BASE_PATH = OBSERVABILITY_BASE_PATH;
const ALERT_PAGE_LINK = `${OBSERVABILITY_BASE_PATH}/alerts`;
exports.ALERT_PAGE_LINK = ALERT_PAGE_LINK;
const RULES_PAGE_LINK = `${ALERT_PAGE_LINK}/rules`;
exports.RULES_PAGE_LINK = RULES_PAGE_LINK;
const SLOS_PAGE_LINK = `${OBSERVABILITY_BASE_PATH}/slos`;
exports.SLOS_PAGE_LINK = SLOS_PAGE_LINK;
const paths = {
  observability: {
    alerts: ALERT_PAGE_LINK,
    alertDetails: alertId => `${ALERT_PAGE_LINK}/${encodeURI(alertId)}`,
    rules: RULES_PAGE_LINK,
    ruleDetails: ruleId => ruleId ? `${RULES_PAGE_LINK}/${encodeURI(ruleId)}` : RULES_PAGE_LINK,
    slos: SLOS_PAGE_LINK,
    slosWelcome: `${SLOS_PAGE_LINK}/welcome`,
    sloCreate: `${SLOS_PAGE_LINK}/create`,
    sloCreateWithEncodedForm: encodedParams => `${SLOS_PAGE_LINK}/create?_a=${encodedParams}`,
    sloEdit: sloId => `${SLOS_PAGE_LINK}/edit/${encodeURI(sloId)}`,
    sloDetails: sloId => `${SLOS_PAGE_LINK}/${encodeURI(sloId)}`
  },
  management: {
    rules: '/app/management/insightsAndAlerting/triggersActions/rules',
    ruleDetails: ruleId => `/app/management/insightsAndAlerting/triggersActions/rule/${encodeURI(ruleId)}`,
    alertDetails: alertId => `/app/management/insightsAndAlerting/triggersActions/alert/${encodeURI(alertId)}`
  }
};
exports.paths = paths;