"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsAlertDropdown = MetricsAlertDropdown;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _alert_flyout = require("./alert_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MetricsAlertDropdown() {
  var _useKibana$services$a;
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [visibleFlyoutType, setVisibleFlyoutType] = (0, _react.useState)(null);
  const uiCapabilities = (_useKibana$services$a = (0, _public.useKibana)().services.application) === null || _useKibana$services$a === void 0 ? void 0 : _useKibana$services$a.capabilities;
  const {
    services: {
      observability
    }
  } = (0, _public.useKibana)();
  const canCreateAlerts = (0, _react.useMemo)(() => {
    var _uiCapabilities$infra;
    return Boolean(uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$infra = uiCapabilities.infrastructure) === null || _uiCapabilities$infra === void 0 ? void 0 : _uiCapabilities$infra.save);
  }, [uiCapabilities]);
  const closeFlyout = (0, _react.useCallback)(() => setVisibleFlyoutType(null), [setVisibleFlyoutType]);
  const closePopover = (0, _react.useCallback)(() => {
    setPopoverOpen(false);
  }, [setPopoverOpen]);
  const togglePopover = (0, _react.useCallback)(() => {
    setPopoverOpen(!popoverOpen);
  }, [setPopoverOpen, popoverOpen]);
  const infrastructureAlertsPanel = (0, _react.useMemo)(() => ({
    id: 1,
    title: _i18n.i18n.translate('xpack.observability.threshold.rule.infrastructureDropdownTitle', {
      defaultMessage: 'Infrastructure rules'
    }),
    items: [{
      'data-test-subj': 'inventory-alerts-create-rule',
      name: _i18n.i18n.translate('xpack.observability.threshold.rule.createInventoryRuleButton', {
        defaultMessage: 'Create inventory rule'
      }),
      onClick: () => {
        closePopover();
        setVisibleFlyoutType('inventory');
      }
    }]
  }), [setVisibleFlyoutType, closePopover]);
  const metricsAlertsPanel = (0, _react.useMemo)(() => ({
    id: 2,
    title: _i18n.i18n.translate('xpack.observability.threshold.rule.metricsDropdownTitle', {
      defaultMessage: 'Metrics rules'
    }),
    items: [{
      'data-test-subj': 'metrics-threshold-alerts-create-rule',
      name: _i18n.i18n.translate('xpack.observability.threshold.rule.createThresholdRuleButton', {
        defaultMessage: 'Create threshold rule'
      }),
      onClick: () => {
        closePopover();
        setVisibleFlyoutType('threshold');
      }
    }]
  }), [setVisibleFlyoutType, closePopover]);
  const manageRulesLinkProps = observability.useRulesLink();
  const manageAlertsMenuItem = (0, _react.useMemo)(() => ({
    name: _i18n.i18n.translate('xpack.observability.threshold.rule.manageRules', {
      defaultMessage: 'Manage rules'
    }),
    icon: 'tableOfContents',
    onClick: manageRulesLinkProps.onClick
  }), [manageRulesLinkProps]);
  const firstPanelMenuItems = (0, _react.useMemo)(() => canCreateAlerts ? [{
    'data-test-subj': 'inventory-alerts-menu-option',
    name: _i18n.i18n.translate('xpack.observability.threshold.rule.infrastructureDropdownMenu', {
      defaultMessage: 'Infrastructure'
    }),
    panel: 1
  }, {
    'data-test-subj': 'metrics-threshold-alerts-menu-option',
    name: _i18n.i18n.translate('xpack.observability.threshold.rule.metricsDropdownMenu', {
      defaultMessage: 'Metrics'
    }),
    panel: 2
  }, manageAlertsMenuItem] : [manageAlertsMenuItem], [canCreateAlerts, manageAlertsMenuItem]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    title: _i18n.i18n.translate('xpack.observability.threshold.rule.alertDropdownTitle', {
      defaultMessage: 'Alerts and rules'
    }),
    items: firstPanelMenuItems
  }].concat(canCreateAlerts ? [infrastructureAlertsPanel, metricsAlertsPanel] : []), [infrastructureAlertsPanel, metricsAlertsPanel, firstPanelMenuItems, canCreateAlerts]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
      color: "text",
      iconSide: 'right',
      iconType: 'arrowDown',
      onClick: togglePopover,
      "data-test-subj": "thresholdRulestructure-alerts-and-rules"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.threshold.rule.alertsButton",
      defaultMessage: "Alerts and rules"
    })),
    isOpen: popoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    "data-test-subj": "metrics-alert-menu"
  })), /*#__PURE__*/_react.default.createElement(AlertFlyout, {
    visibleFlyoutType: visibleFlyoutType,
    onClose: closeFlyout
  }));
}
function AlertFlyout({
  visibleFlyoutType,
  onClose
}) {
  switch (visibleFlyoutType) {
    case 'threshold':
      return /*#__PURE__*/_react.default.createElement(_alert_flyout.PrefilledThresholdAlertFlyout, {
        onClose: onClose
      });
    default:
      return null;
  }
}