"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Expressions;
exports.defaultExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/stack-alerts-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _kibana_react = require("../../../utils/kibana_react");
var _types = require("../../../../common/threshold_rule/types");
var _expression_chart = require("./expression_chart");
var _expression_row = require("./expression_row");
var _kuery_bar = require("./kuery_bar");
var _kuery = require("../helpers/kuery");
var _group_by = require("./group_by");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_TYPING_DEBOUNCE_MS = 500;
const defaultExpression = {
  aggType: _types.Aggregators.CUSTOM,
  comparator: _types.Comparator.GT,
  threshold: [],
  timeSize: 1,
  timeUnit: 'm'
};

// eslint-disable-next-line import/no-default-export
exports.defaultExpression = defaultExpression;
function Expressions(props) {
  const {
    setRuleParams,
    ruleParams,
    errors,
    metadata,
    onChangeMetaData
  } = props;
  const {
    data,
    dataViews,
    dataViewEditor,
    docLinks
  } = (0, _kibana_react.useKibana)().services;
  const [timeSize, setTimeSize] = (0, _react.useState)(1);
  const [timeUnit, setTimeUnit] = (0, _react.useState)('m');
  const [dataView, setDataView] = (0, _react.useState)();
  const [searchSource, setSearchSource] = (0, _react.useState)();
  const derivedIndexPattern = (0, _react.useMemo)(() => ({
    fields: (dataView === null || dataView === void 0 ? void 0 : dataView.fields) || [],
    title: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) || 'unknown-index'
  }), [dataView]);
  (0, _react.useEffect)(() => {
    const initSearchSource = async () => {
      let initialSearchConfiguration = ruleParams.searchConfiguration;
      if (!ruleParams.searchConfiguration) {
        const newSearchSource = data.search.searchSource.createEmpty();
        newSearchSource.setField('query', data.query.queryString.getDefaultQuery());
        const defaultDataView = await data.dataViews.getDefaultDataView();
        if (defaultDataView) {
          newSearchSource.setField('index', defaultDataView);
          setDataView(defaultDataView);
        }
        initialSearchConfiguration = newSearchSource.getSerializedFields();
      }
      try {
        const createdSearchSource = await data.search.searchSource.create(initialSearchConfiguration);
        setRuleParams('searchConfiguration', initialSearchConfiguration);
        setSearchSource(createdSearchSource);
        setDataView(createdSearchSource.getField('index'));
      } catch (error) {
        // TODO Handle error
        console.log('error:', error);
      }
    };
    initSearchSource();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data.search.searchSource, data.dataViews]);
  const options = (0, _react.useMemo)(() => {
    var _metadata$currentOpti;
    if (metadata !== null && metadata !== void 0 && (_metadata$currentOpti = metadata.currentOptions) !== null && _metadata$currentOpti !== void 0 && _metadata$currentOpti.metrics) {
      return metadata.currentOptions;
    } else {
      return {
        metrics: [],
        aggregation: 'avg'
      };
    }
  }, [metadata]);
  const onSelectDataView = (0, _react.useCallback)(newDataView => {
    const ruleCriteria = (ruleParams.criteria ? ruleParams.criteria.slice() : []).map(criterion => {
      var _criterion$customMetr;
      (_criterion$customMetr = criterion.customMetrics) === null || _criterion$customMetr === void 0 ? void 0 : _criterion$customMetr.forEach(metric => {
        metric.field = undefined;
      });
      return criterion;
    });
    setRuleParams('criteria', ruleCriteria);
    searchSource === null || searchSource === void 0 ? void 0 : searchSource.setParent(undefined).setField('index', newDataView);
    setRuleParams('searchConfiguration', searchSource === null || searchSource === void 0 ? void 0 : searchSource.getSerializedFields());
    setDataView(newDataView);
  }, [ruleParams.criteria, searchSource, setRuleParams]);
  const updateParams = (0, _react.useCallback)((id, e) => {
    const ruleCriteria = ruleParams.criteria ? ruleParams.criteria.slice() : [];
    ruleCriteria[id] = e;
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria]);
  const addExpression = (0, _react.useCallback)(() => {
    var _ruleParams$criteria;
    const ruleCriteria = ((_ruleParams$criteria = ruleParams.criteria) === null || _ruleParams$criteria === void 0 ? void 0 : _ruleParams$criteria.slice()) || [];
    ruleCriteria.push({
      ...defaultExpression,
      timeSize: timeSize !== null && timeSize !== void 0 ? timeSize : defaultExpression.timeSize,
      timeUnit: timeUnit !== null && timeUnit !== void 0 ? timeUnit : defaultExpression.timeUnit
    });
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria, timeSize, timeUnit]);
  const removeExpression = (0, _react.useCallback)(id => {
    var _ruleParams$criteria2;
    const ruleCriteria = ((_ruleParams$criteria2 = ruleParams.criteria) === null || _ruleParams$criteria2 === void 0 ? void 0 : _ruleParams$criteria2.slice()) || [];
    if (ruleCriteria.length > 1) {
      ruleCriteria.splice(id, 1);
      setRuleParams('criteria', ruleCriteria);
    }
  }, [setRuleParams, ruleParams.criteria]);
  const onFilterChange = (0, _react.useCallback)(filter => {
    setRuleParams('filterQueryText', filter);
    try {
      setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(filter, derivedIndexPattern, false) || '');
    } catch (e) {
      setRuleParams('filterQuery', _types.QUERY_INVALID);
    }
  }, [setRuleParams, derivedIndexPattern]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedOnFilterChange = (0, _react.useCallback)((0, _lodash.debounce)(onFilterChange, FILTER_TYPING_DEBOUNCE_MS), [onFilterChange]);
  const onGroupByChange = (0, _react.useCallback)(group => {
    setRuleParams('groupBy', group && group.length ? group : '');
  }, [setRuleParams]);
  const emptyError = (0, _react.useMemo)(() => {
    return {
      aggField: [],
      timeSizeUnit: [],
      timeWindowSize: []
    };
  }, []);
  const updateTimeSize = (0, _react.useCallback)(ts => {
    var _ruleParams$criteria3;
    const ruleCriteria = ((_ruleParams$criteria3 = ruleParams.criteria) === null || _ruleParams$criteria3 === void 0 ? void 0 : _ruleParams$criteria3.map(c => ({
      ...c,
      timeSize: ts
    }))) || [];
    setTimeSize(ts || undefined);
    setRuleParams('criteria', ruleCriteria);
  }, [ruleParams.criteria, setRuleParams]);
  const updateTimeUnit = (0, _react.useCallback)(tu => {
    var _ruleParams$criteria4;
    const ruleCriteria = ((_ruleParams$criteria4 = ruleParams.criteria) === null || _ruleParams$criteria4 === void 0 ? void 0 : _ruleParams$criteria4.map(c => ({
      ...c,
      timeUnit: tu
    }))) || [];
    setTimeUnit(tu);
    setRuleParams('criteria', ruleCriteria);
  }, [ruleParams.criteria, setRuleParams]);
  const preFillAlertCriteria = (0, _react.useCallback)(() => {
    var _md$currentOptions, _md$currentOptions$me;
    const md = metadata;
    if (md !== null && md !== void 0 && (_md$currentOptions = md.currentOptions) !== null && _md$currentOptions !== void 0 && (_md$currentOptions$me = _md$currentOptions.metrics) !== null && _md$currentOptions$me !== void 0 && _md$currentOptions$me.length) {
      setRuleParams('criteria', md.currentOptions.metrics.map(metric => ({
        metric: metric.field,
        comparator: _types.Comparator.GT,
        threshold: [],
        timeSize,
        timeUnit,
        aggType: metric.aggregation
      })));
    } else {
      setRuleParams('criteria', [defaultExpression]);
    }
  }, [metadata, setRuleParams, timeSize, timeUnit]);
  const preFillAlertFilter = (0, _react.useCallback)(() => {
    var _md$currentOptions2, _md$currentOptions3;
    const md = metadata;
    if (md && (_md$currentOptions2 = md.currentOptions) !== null && _md$currentOptions2 !== void 0 && _md$currentOptions2.filterQuery) {
      setRuleParams('filterQueryText', md.currentOptions.filterQuery);
      setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(md.currentOptions.filterQuery, derivedIndexPattern) || '');
    } else if (md && (_md$currentOptions3 = md.currentOptions) !== null && _md$currentOptions3 !== void 0 && _md$currentOptions3.groupBy && md.series) {
      const {
        groupBy
      } = md.currentOptions;
      const filter = Array.isArray(groupBy) ? groupBy.map((field, index) => {
        var _md$series, _md$series$keys;
        return `${field}: "${(_md$series = md.series) === null || _md$series === void 0 ? void 0 : (_md$series$keys = _md$series.keys) === null || _md$series$keys === void 0 ? void 0 : _md$series$keys[index]}"`;
      }).join(' and ') : `${groupBy}: "${md.series.id}"`;
      setRuleParams('filterQueryText', filter);
      setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(filter, derivedIndexPattern) || '');
    }
  }, [metadata, derivedIndexPattern, setRuleParams]);
  const preFillAlertGroupBy = (0, _react.useCallback)(() => {
    var _md$currentOptions4;
    const md = metadata;
    if (md && (_md$currentOptions4 = md.currentOptions) !== null && _md$currentOptions4 !== void 0 && _md$currentOptions4.groupBy && !md.series) {
      setRuleParams('groupBy', md.currentOptions.groupBy);
    }
  }, [metadata, setRuleParams]);
  (0, _react.useEffect)(() => {
    if (ruleParams.criteria && ruleParams.criteria.length) {
      setTimeSize(ruleParams.criteria[0].timeSize);
      setTimeUnit(ruleParams.criteria[0].timeUnit);
    } else {
      preFillAlertCriteria();
    }
    if (!ruleParams.filterQuery) {
      preFillAlertFilter();
    }
    if (!ruleParams.groupBy) {
      preFillAlertGroupBy();
    }
    if (typeof ruleParams.alertOnNoData === 'undefined') {
      setRuleParams('alertOnNoData', true);
    }
    if (typeof ruleParams.alertOnGroupDisappear === 'undefined') {
      setRuleParams('alertOnGroupDisappear', true);
    }
  }, [metadata]); // eslint-disable-line react-hooks/exhaustive-deps

  const handleFieldSearchChange = (0, _react.useCallback)(e => onFilterChange(e.target.value), [onFilterChange]);
  const hasGroupBy = (0, _react.useMemo)(() => ruleParams.groupBy && ruleParams.groupBy.length > 0, [ruleParams.groupBy]);
  const disableNoData = (0, _react.useMemo)(() => {
    var _ruleParams$criteria5;
    return (_ruleParams$criteria5 = ruleParams.criteria) === null || _ruleParams$criteria5 === void 0 ? void 0 : _ruleParams$criteria5.every(c => c.aggType === _types.Aggregators.COUNT);
  }, [ruleParams.criteria]);

  // Test to see if any of the group fields in groupBy are already filtered down to a single
  // group by the filterQuery. If this is the case, then a groupBy is unnecessary, as it would only
  // ever produce one group instance
  const groupByFilterTestPatterns = (0, _react.useMemo)(() => {
    if (!ruleParams.groupBy) return null;
    const groups = !Array.isArray(ruleParams.groupBy) ? [ruleParams.groupBy] : ruleParams.groupBy;
    return groups.map(group => ({
      groupName: group,
      pattern: new RegExp(`{"match(_phrase)?":{"${group}":"(.*?)"}}`)
    }));
  }, [ruleParams.groupBy]);
  const redundantFilterGroupBy = (0, _react.useMemo)(() => {
    const {
      filterQuery
    } = ruleParams;
    if (typeof filterQuery !== 'string' || !groupByFilterTestPatterns) return [];
    return groupByFilterTestPatterns.map(({
      groupName,
      pattern
    }) => {
      if (pattern.test(filterQuery)) {
        return groupName;
      }
    }).filter(g => typeof g === 'string');
  }, [ruleParams, groupByFilterTestPatterns]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.DataViewSelectPopover, {
    dependencies: {
      dataViews,
      dataViewEditor
    },
    dataView: dataView,
    onSelectDataView: onSelectDataView,
    onChangeMetaData: ({
      adHocDataViewList
    }) => {
      onChangeMetaData({
        ...metadata,
        adHocDataViewList
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.threshold.rule.alertFlyout.conditions",
    defaultMessage: "Conditions"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs'
  }), ruleParams.criteria && ruleParams.criteria.map((e, idx) => {
    return /*#__PURE__*/_react.default.createElement(_expression_row.ExpressionRow, {
      canDelete: ruleParams.criteria && ruleParams.criteria.length > 1 || false,
      fields: derivedIndexPattern.fields,
      remove: removeExpression,
      addExpression: addExpression,
      key: idx // idx's don't usually make good key's but here the index has semantic meaning
      ,
      expressionId: idx,
      setRuleParams: updateParams,
      errors: errors[idx] || emptyError,
      expression: e || {},
      dataView: derivedIndexPattern
    }, /*#__PURE__*/_react.default.createElement(_expression_chart.ExpressionChart, {
      expression: e,
      derivedIndexPattern: derivedIndexPattern,
      filterQuery: ruleParams.filterQueryText,
      groupBy: ruleParams.groupBy
    }));
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginLeft: 28
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    timeWindowSize: timeSize,
    timeWindowUnit: timeUnit,
    errors: emptyError,
    onChangeWindowSize: updateTimeSize,
    onChangeWindowUnit: updateTimeUnit
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "thresholdRuleExpressionsAddConditionButton",
    color: 'primary',
    iconSide: 'left',
    flush: 'left',
    iconType: 'plusInCircleFilled',
    onClick: addExpression
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.threshold.rule.alertFlyout.addCondition",
    defaultMessage: "Add condition"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advanced-options-accordion",
    buttonContent: _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.advancedOptions', {
      defaultMessage: 'Advanced options'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    disabled: disableNoData,
    id: "metrics-alert-no-data-toggle",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.alertOnNoData', {
      defaultMessage: "Alert me if there's no data"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: (disableNoData ? `${docCountNoDataDisabledHelpText} ` : '') + _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.noDataHelpText', {
        defaultMessage: 'Enable this to trigger the action if the metric(s) do not report any data over the expected time period, or if the alert fails to query Elasticsearch'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      color: "subdued"
    }))),
    checked: ruleParams.alertOnNoData,
    onChange: e => setRuleParams('alertOnNoData', e.target.checked)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.filterLabel', {
      defaultMessage: 'Filter (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.filterHelpText', {
      defaultMessage: 'Use a KQL expression to limit the scope of your alert trigger.'
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, metadata && derivedIndexPattern && /*#__PURE__*/_react.default.createElement(_kuery_bar.MetricsExplorerKueryBar, {
    derivedIndexPattern: derivedIndexPattern,
    onChange: debouncedOnFilterChange,
    onSubmit: onFilterChange,
    value: ruleParams.filterQueryText
  }) || /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "thresholdRuleExpressionsFieldSearch",
    onChange: handleFieldSearchChange,
    value: ruleParams.filterQueryText,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.createAlertPerText', {
      defaultMessage: 'Group alerts by (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "host.id" or "cloud.region".'
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_group_by.MetricsExplorerGroupBy, {
    onChange: onGroupByChange,
    fields: derivedIndexPattern.fields,
    options: {
      ...options,
      groupBy: ruleParams.groupBy || undefined
    },
    errorOptions: redundantFilterGroupBy
  })), redundantFilterGroupBy.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.threshold.rule.alertFlyout.alertPerRedundantFilterError",
    defaultMessage: "This rule may alert on {matchedGroups} less than expected, because the filter query contains a match for {groupCount, plural, one {this field} other {these fields}}. For more information, refer to {filteringAndGroupingLink}.",
    values: {
      matchedGroups: /*#__PURE__*/_react.default.createElement("strong", null, redundantFilterGroupBy.join(', ')),
      groupCount: redundantFilterGroupBy.length,
      filteringAndGroupingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "thresholdRuleExpressionsTheDocsLink",
        href: `${docLinks.links.observability.metricsThreshold}#filtering-and-grouping`
      }, _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.alertPerRedundantFilterError.docsLink', {
        defaultMessage: 'the docs'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "metrics-alert-group-disappear-toggle",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.alertOnGroupDisappear', {
      defaultMessage: 'Alert me if a group stops reporting data'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: (disableNoData ? `${docCountNoDataDisabledHelpText} ` : '') + _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.groupDisappearHelpText', {
        defaultMessage: 'Enable this to trigger the action if a previously detected group begins to report no results. This is not recommended for dynamically scaling infrastructures that may rapidly start and stop nodes automatically.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      color: "subdued"
    }))),
    disabled: disableNoData || !hasGroupBy,
    checked: Boolean(hasGroupBy && ruleParams.alertOnGroupDisappear),
    onChange: e => setRuleParams('alertOnGroupDisappear', e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }));
}
const docCountNoDataDisabledHelpText = _i18n.i18n.translate('xpack.observability.threshold.rule.alertFlyout.docCountNoDataDisabledHelpText', {
  defaultMessage: '[This setting is not applicable to the Document Count aggregator.]'
});