"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CoPilotPrompt;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _co_pilot_prompt_feedback = require("./co_pilot_prompt_feedback");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cursorCss = (0, _css.css)`
  @keyframes blink {
    0% {
      opacity: 1;
    }
    50% {
      opacity: 0;
    }
    100% {
      opacity: 1;
    }
  }

  animation: blink 1s infinite;
  width: 10px;
  height: 16px;
  vertical-align: middle;
  display: inline-block;
  background: rgba(0, 0, 0, 0.25);
`;
// eslint-disable-next-line import/no-default-export
function CoPilotPrompt({
  title,
  coPilot,
  promptId,
  params,
  feedbackEnabled
}) {
  var _conversation$message;
  const [hasOpened, setHasOpened] = (0, _react.useState)(false);
  const theme = (0, _eui.useEuiTheme)();
  const [responseTime, setResponseTime] = (0, _react.useState)(undefined);
  const conversation$ = (0, _react.useMemo)(() => {
    if (hasOpened) {
      setResponseTime(undefined);
      const now = Date.now();
      const observable = coPilot.prompt(promptId, params).pipe((0, _rxjs.catchError)(err => (0, _rxjs.of)({
        messages: [],
        loading: false,
        error: err,
        message: String(err.message)
      })));
      observable.subscribe({
        complete: () => {
          setResponseTime(Date.now() - now);
        }
      });
      return observable;
    }
    return new _rxjs.Observable(() => {});
  }, [params, promptId, coPilot, hasOpened, setResponseTime]);
  const conversation = (0, _useObservable.default)(conversation$);
  const content = (_conversation$message = conversation === null || conversation === void 0 ? void 0 : conversation.message) !== null && _conversation$message !== void 0 ? _conversation$message : '';
  const messages = conversation === null || conversation === void 0 ? void 0 : conversation.messages;
  let state = 'init';
  if (conversation !== null && conversation !== void 0 && conversation.loading) {
    state = content ? 'streaming' : 'loading';
  } else if (conversation && 'error' in conversation && conversation.error) {
    state = 'error';
  } else if (content) {
    state = 'complete';
  }
  let inner;
  if (state === 'complete' || state === 'streaming') {
    inner = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      style: {
        whiteSpace: 'pre-wrap',
        lineHeight: 1.5
      }
    }, content, state === 'streaming' ? /*#__PURE__*/_react.default.createElement("span", {
      className: cursorCss
    }) : undefined), state === 'complete' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), coPilot.isTrackingEnabled() && feedbackEnabled ? /*#__PURE__*/_react.default.createElement(_co_pilot_prompt_feedback.CoPilotPromptFeedback, {
      messages: messages,
      response: content,
      responseTime: responseTime,
      promptId: promptId,
      coPilot: coPilot
    }) : undefined) : undefined);
  } else if (state === 'init' || state === 'loading') {
    inner = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.observability.coPilotPrompt.chatLoading', {
      defaultMessage: 'Waiting for a response...'
    }))));
  } else {
    /* if (state === 'error') {*/
    inner = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "danger",
      type: "warning"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, content)));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: title,
    css: (0, _css.css)`
          .euiButtonIcon {
            color: ${theme.euiTheme.colors.primaryText};
          }
        `,
    buttonClassName: (0, _css.css)`
          display: block;
          width: 100%;
        `,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      color: theme.euiTheme.colors.primaryText
    }, /*#__PURE__*/_react.default.createElement("strong", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: theme.euiTheme.colors.primaryText
    }, _i18n.i18n.translate('xpack.observability.coPilotChatPrompt.subtitle', {
      defaultMessage: 'Get helpful insights from our Elastic AI Assistant'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_public.TechnicalPreviewBadge, null))),
    initialIsOpen: false,
    onToggle: () => {
      setHasOpened(true);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), inner));
}
module.exports = exports.default;