"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsStatusFilter = AlertsStatusFilter;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = [{
  id: _constants.ALL_ALERTS.status,
  label: _constants.ALL_ALERTS.label,
  value: _constants.ALL_ALERTS.query,
  'data-test-subj': 'alert-status-filter-show-all-button'
}, {
  id: _constants.ACTIVE_ALERTS.status,
  label: _constants.ACTIVE_ALERTS.label,
  value: _constants.ACTIVE_ALERTS.query,
  'data-test-subj': 'alert-status-filter-active-button'
}, {
  id: _constants.RECOVERED_ALERTS.status,
  label: _constants.RECOVERED_ALERTS.label,
  value: _constants.RECOVERED_ALERTS.query,
  'data-test-subj': 'alert-status-filter-recovered-button'
}];
function AlertsStatusFilter({
  status,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.observability.alerts.alertStatusFilter.legend', {
      defaultMessage: 'Filter by'
    }),
    color: "primary",
    options: options,
    idSelected: status,
    onChange: id => onChange(id)
  });
}