"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsSourceStatusRT = exports.logIndexReferenceRT = exports.logIndexNameReferenceRT = exports.logDataViewReferenceRT = exports.getLogAlertsChartPreviewDataSuccessResponsePayloadRT = exports.ThresholdFormatterTypeRT = exports.SourceStatusRuntimeType = exports.SourceConfigurationTimestampColumnRuntimeType = exports.SourceConfigurationMessageColumnRuntimeType = exports.SourceConfigurationFieldColumnRuntimeType = exports.SourceConfigurationColumnRuntimeType = exports.SnapshotCustomMetricInputRT = exports.SnapshotCustomAggregationRT = exports.QUERY_INVALID = exports.MetricsExplorerChartType = exports.InfraRuleType = exports.InfraFormatterType = exports.Comparator = exports.AlertStates = exports.Aggregators = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _color_palette = require("./color_palette");
var _metrics_explorer = require("./metrics_explorer");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThresholdFormatterTypeRT = rt.keyof({
  abbreviatedNumber: null,
  bits: null,
  bytes: null,
  number: null,
  percent: null,
  highPrecision: null
});
exports.ThresholdFormatterTypeRT = ThresholdFormatterTypeRT;
const pointRT = rt.type({
  timestamp: rt.number,
  value: rt.number
});
const serieRT = rt.type({
  id: rt.string,
  points: rt.array(pointRT)
});
const seriesRT = rt.array(serieRT);
const getLogAlertsChartPreviewDataSuccessResponsePayloadRT = rt.type({
  data: rt.type({
    series: seriesRT
  })
});
exports.getLogAlertsChartPreviewDataSuccessResponsePayloadRT = getLogAlertsChartPreviewDataSuccessResponsePayloadRT;
/**
 * Properties specific to the Metrics Source Configuration.
 */
const SourceConfigurationTimestampColumnRuntimeType = rt.type({
  timestampColumn: rt.type({
    id: rt.string
  })
});
exports.SourceConfigurationTimestampColumnRuntimeType = SourceConfigurationTimestampColumnRuntimeType;
const SourceConfigurationMessageColumnRuntimeType = rt.type({
  messageColumn: rt.type({
    id: rt.string
  })
});
exports.SourceConfigurationMessageColumnRuntimeType = SourceConfigurationMessageColumnRuntimeType;
const SourceConfigurationFieldColumnRuntimeType = rt.type({
  fieldColumn: rt.type({
    id: rt.string,
    field: rt.string
  })
});
exports.SourceConfigurationFieldColumnRuntimeType = SourceConfigurationFieldColumnRuntimeType;
const SourceConfigurationColumnRuntimeType = rt.union([SourceConfigurationTimestampColumnRuntimeType, SourceConfigurationMessageColumnRuntimeType, SourceConfigurationFieldColumnRuntimeType]);

// Kibana data views
exports.SourceConfigurationColumnRuntimeType = SourceConfigurationColumnRuntimeType;
const logDataViewReferenceRT = rt.type({
  type: rt.literal('data_view'),
  dataViewId: rt.string
});

// Index name
exports.logDataViewReferenceRT = logDataViewReferenceRT;
const logIndexNameReferenceRT = rt.type({
  type: rt.literal('index_name'),
  indexName: rt.string
});
exports.logIndexNameReferenceRT = logIndexNameReferenceRT;
const logIndexReferenceRT = rt.union([logDataViewReferenceRT, logIndexNameReferenceRT]);

/**
 * Source status
 */
exports.logIndexReferenceRT = logIndexReferenceRT;
const SourceStatusFieldRuntimeType = rt.type({
  name: rt.string,
  type: rt.string,
  searchable: rt.boolean,
  aggregatable: rt.boolean,
  displayable: rt.boolean
});
const SourceStatusRuntimeType = rt.type({
  logIndicesExist: rt.boolean,
  metricIndicesExist: rt.boolean,
  remoteClustersExist: rt.boolean,
  indexFields: rt.array(SourceStatusFieldRuntimeType)
});
exports.SourceStatusRuntimeType = SourceStatusRuntimeType;
const metricsSourceStatusRT = rt.strict({
  metricIndicesExist: SourceStatusRuntimeType.props.metricIndicesExist,
  remoteClustersExist: SourceStatusRuntimeType.props.metricIndicesExist,
  indexFields: SourceStatusRuntimeType.props.indexFields
});
exports.metricsSourceStatusRT = metricsSourceStatusRT;
let Comparator;
exports.Comparator = Comparator;
(function (Comparator) {
  Comparator["GT"] = ">";
  Comparator["LT"] = "<";
  Comparator["GT_OR_EQ"] = ">=";
  Comparator["LT_OR_EQ"] = "<=";
  Comparator["BETWEEN"] = "between";
  Comparator["OUTSIDE_RANGE"] = "outside";
})(Comparator || (exports.Comparator = Comparator = {}));
let Aggregators;
exports.Aggregators = Aggregators;
(function (Aggregators) {
  Aggregators["COUNT"] = "count";
  Aggregators["AVERAGE"] = "avg";
  Aggregators["SUM"] = "sum";
  Aggregators["MIN"] = "min";
  Aggregators["MAX"] = "max";
  Aggregators["RATE"] = "rate";
  Aggregators["CARDINALITY"] = "cardinality";
  Aggregators["P95"] = "p95";
  Aggregators["P99"] = "p99";
  Aggregators["CUSTOM"] = "custom";
})(Aggregators || (exports.Aggregators = Aggregators = {}));
const metricsExplorerOptionsMetricRT = rt.intersection([_metrics_explorer.metricsExplorerMetricRT, rt.partial({
  rate: rt.boolean,
  color: rt.keyof(Object.fromEntries((0, _lodash.values)(_color_palette.Color).map(c => [c, null]))),
  label: rt.string
})]);
let MetricsExplorerChartType;
exports.MetricsExplorerChartType = MetricsExplorerChartType;
(function (MetricsExplorerChartType) {
  MetricsExplorerChartType["line"] = "line";
  MetricsExplorerChartType["area"] = "area";
  MetricsExplorerChartType["bar"] = "bar";
})(MetricsExplorerChartType || (exports.MetricsExplorerChartType = MetricsExplorerChartType = {}));
let InfraRuleType;
exports.InfraRuleType = InfraRuleType;
(function (InfraRuleType) {
  InfraRuleType["MetricThreshold"] = "metrics.alert.threshold";
  InfraRuleType["InventoryThreshold"] = "metrics.alert.inventory.threshold";
  InfraRuleType["Anomaly"] = "metrics.alert.anomaly";
})(InfraRuleType || (exports.InfraRuleType = InfraRuleType = {}));
let AlertStates;
exports.AlertStates = AlertStates;
(function (AlertStates) {
  AlertStates[AlertStates["OK"] = 0] = "OK";
  AlertStates[AlertStates["ALERT"] = 1] = "ALERT";
  AlertStates[AlertStates["WARNING"] = 2] = "WARNING";
  AlertStates[AlertStates["NO_DATA"] = 3] = "NO_DATA";
  AlertStates[AlertStates["ERROR"] = 4] = "ERROR";
})(AlertStates || (exports.AlertStates = AlertStates = {}));
const metricAnomalyNodeTypeRT = rt.union([rt.literal('hosts'), rt.literal('k8s')]);
const metricAnomalyMetricRT = rt.union([rt.literal('memory_usage'), rt.literal('network_in'), rt.literal('network_out')]);
const metricAnomalyInfluencerFilterRT = rt.type({
  fieldName: rt.string,
  fieldValue: rt.string
});
const QUERY_INVALID = Symbol('QUERY_INVALID');
exports.QUERY_INVALID = QUERY_INVALID;
let InfraFormatterType;
exports.InfraFormatterType = InfraFormatterType;
(function (InfraFormatterType) {
  InfraFormatterType["number"] = "number";
  InfraFormatterType["abbreviatedNumber"] = "abbreviatedNumber";
  InfraFormatterType["bytes"] = "bytes";
  InfraFormatterType["bits"] = "bits";
  InfraFormatterType["percent"] = "percent";
})(InfraFormatterType || (exports.InfraFormatterType = InfraFormatterType = {}));
const snapshotCustomAggregationKeys = _constants.SNAPSHOT_CUSTOM_AGGREGATIONS.reduce((acc, agg) => ({
  ...acc,
  [agg]: null
}), {});
const SnapshotCustomAggregationRT = rt.keyof(snapshotCustomAggregationKeys);
exports.SnapshotCustomAggregationRT = SnapshotCustomAggregationRT;
const SnapshotCustomMetricInputRT = rt.intersection([rt.type({
  type: rt.literal('custom'),
  field: rt.string,
  aggregation: SnapshotCustomAggregationRT,
  id: rt.string
}), rt.partial({
  label: rt.string
})]);
exports.SnapshotCustomMetricInputRT = SnapshotCustomMetricInputRT;