"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findLatestObservabilityOnboardingState = findLatestObservabilityOnboardingState;
var _observability_onboarding_status = require("../../saved_objects/observability_onboarding_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function findLatestObservabilityOnboardingState({
  savedObjectsClient
}) {
  const result = await savedObjectsClient.find({
    type: _observability_onboarding_status.OBSERVABILITY_ONBOARDING_STATE_SAVED_OBJECT_TYPE,
    page: 1,
    perPage: 1,
    sortField: `updated_at`,
    sortOrder: 'desc'
  });
  if (result.total === 0) {
    return undefined;
  }
  const {
    id,
    updated_at: updatedAt,
    attributes
  } = result.saved_objects[0];
  return {
    id,
    updatedAt: updatedAt ? Date.parse(updatedAt) : 0,
    ...attributes
  };
}