"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePublishedDate = exports.validateIntegrity = exports.localizeItem = exports.convertItems = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertItems = (items, userLanguage) => {
  return items.filter(validatePublishedDate).map(item => localizeItem(item, userLanguage)).filter(validateIntegrity);
};
exports.convertItems = convertItems;
const validatePublishedDate = item => {
  if ((0, _moment.default)(item.expire_on).isBefore(Date.now())) {
    return false; // ignore item if expired
  }

  if ((0, _moment.default)(item.publish_on).isAfter(Date.now())) {
    return false; // ignore item if publish date hasn't occurred yet (pre-published)
  }

  return true;
};
exports.validatePublishedDate = validatePublishedDate;
const localizeItem = (rawItem, userLanguage) => {
  const {
    expire_on: expireOnUtc,
    publish_on: publishOnUtc,
    languages,
    title,
    description,
    link_text: linkText,
    link_url: linkUrl,
    badge,
    hash
  } = rawItem;
  let chosenLanguage = userLanguage;
  if (!languages || !languages.includes(chosenLanguage)) {
    chosenLanguage = _constants.NEWSFEED_FALLBACK_LANGUAGE; // don't remove the item: fallback on a language
  }

  return {
    title: title[chosenLanguage],
    description: description[chosenLanguage],
    linkText: linkText != null ? linkText[chosenLanguage] : null,
    linkUrl: linkUrl[chosenLanguage],
    badge: badge != null ? badge[chosenLanguage] : null,
    publishOn: (0, _moment.default)(publishOnUtc),
    expireOn: (0, _moment.default)(expireOnUtc),
    hash: hash.slice(0, 10) // optimize for storage and faster parsing
  };
};
exports.localizeItem = localizeItem;
const validateIntegrity = item => {
  const hasMissing = [item.title, item.description, item.linkText, item.linkUrl, item.publishOn, item.hash].includes(undefined);
  return !hasMissing;
};
exports.validateIntegrity = validateIntegrity;