"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsfeedNavButton = exports.NewsfeedContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _flyout_list = require("./flyout_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NewsfeedContext = /*#__PURE__*/_react.default.createContext({});
exports.NewsfeedContext = NewsfeedContext;
const NewsfeedNavButton = ({
  newsfeedApi,
  hasCustomBranding$
}) => {
  const [flyoutVisible, setFlyoutVisible] = (0, _react.useState)(false);
  const [newsFetchResult, setNewsFetchResult] = (0, _react.useState)(null);
  const hasCustomBranding = (0, _useObservable.default)(hasCustomBranding$, false);
  const hasNew = (0, _react.useMemo)(() => {
    return newsFetchResult ? newsFetchResult.hasNew : false;
  }, [newsFetchResult]);
  const buttonRef = (0, _react.useRef)(null);
  const setButtonRef = node => buttonRef.current = node;
  (0, _react.useEffect)(() => {
    const subscription = newsfeedApi.fetchResults$.subscribe(results => {
      setNewsFetchResult(results);
    });
    return () => subscription.unsubscribe();
  }, [newsfeedApi]);
  const showFlyout = (0, _react.useCallback)(() => {
    if (newsFetchResult) {
      newsfeedApi.markAsRead(newsFetchResult.feedItems.map(item => item.hash));
    }
    setFlyoutVisible(!flyoutVisible);
  }, [newsfeedApi, newsFetchResult, flyoutVisible]);
  return /*#__PURE__*/_react.default.createElement(NewsfeedContext.Provider, {
    value: {
      setFlyoutVisible,
      newsFetchResult
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
    ref: setButtonRef,
    "data-test-subj": "newsfeed",
    "aria-controls": "keyPadMenu",
    "aria-expanded": flyoutVisible,
    "aria-haspopup": "true",
    "aria-label": hasNew ? _i18n.i18n.translate('newsfeed.headerButton.unreadAriaLabel', {
      defaultMessage: 'Newsfeed menu - unread items available'
    }) : _i18n.i18n.translate('newsfeed.headerButton.readAriaLabel', {
      defaultMessage: 'Newsfeed menu - all items read'
    }),
    notification: hasNew ? true : null,
    onClick: showFlyout
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "cheer",
    size: "m"
  })), flyoutVisible ? /*#__PURE__*/_react.default.createElement(_flyout_list.NewsfeedFlyout, {
    focusTrapProps: {
      shards: [buttonRef]
    },
    showPlainSpinner: hasCustomBranding
  }) : null));
};
exports.NewsfeedNavButton = NewsfeedNavButton;