"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMonitoringSSPTable = EuiMonitoringSSPTable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatting = require("../setup_mode/formatting");
var _setup_mode = require("../../lib/setup_mode");
var _enums = require("../../../common/enums");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EuiMonitoringSSPTable({
  rows: items,
  search = {},
  pagination,
  columns: _columns,
  onTableChange,
  setupMode,
  productName,
  ...props
}) {
  const [queryText, setQueryText] = _react.default.useState('');
  const [isLoading, setIsLoading] = _react.default.useState(false);
  const [page, setPage] = _react.default.useState({
    index: pagination.pageIndex,
    size: pagination.pageSize
  });
  if (!pagination.totalItemCount) {
    pagination.totalItemCount = items && items.length || 0;
  }
  const [sort, setSort] = _react.default.useState(props.sorting);
  if (search.box && !search.box['data-test-subj']) {
    search.box['data-test-subj'] = 'monitoringTableToolBar';
  }
  const columns = _columns.map(column => {
    if (!('sortable' in column)) {
      column.sortable = true;
    }
    return column;
  });
  let footerContent = null;
  if (setupMode && setupMode.enabled && (0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
    footerContent = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "flag",
      onClick: () => setupMode.openFlyout({}, true)
    }, _i18n.i18n.translate('xpack.monitoring.euiSSPTable.setupNewButtonLabel', {
      defaultMessage: 'Set up monitoring for new {identifier}',
      values: {
        identifier: (0, _formatting.getIdentifier)(productName)
      }
    })));
  }
  const onChange = async ({
    page,
    sort
  }) => {
    setPage(page);
    setSort({
      sort
    });
    // angular version
    if (props.fetchMoreData) {
      setIsLoading(true);
      await props.fetchMoreData({
        page,
        sort: {
          sort
        },
        queryText
      });
      setIsLoading(false);
      onTableChange({
        page,
        sort
      });
    }
    // react version
    else {
      onTableChange({
        page,
        sort,
        queryText
      });
    }
  };
  const onQueryChange = async ({
    queryText
  }) => {
    const newPage = {
      ...page,
      index: 0
    };
    setPage(newPage);
    setQueryText(queryText);
    // angular version
    if (props.fetchMoreData) {
      setIsLoading(true);
      await props.fetchMoreData({
        page: newPage,
        sort,
        queryText
      });
      setIsLoading(false);
    } else {
      // react version
      onTableChange({
        page,
        sort: sort.sort,
        queryText
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${props.className}Container`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, (0, _extends2.default)({}, search, {
    onChange: onQueryChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({}, props, {
    "data-test-subj": items.length ? 'monitoringTableHasData' : 'monitoringTableNoData',
    items: items,
    pagination: pagination,
    onChange: onChange,
    columns: columns,
    loading: props.isLoading || isLoading
  })), footerContent);
}