"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchMLJobs = void 0;
var _lodash = require("lodash");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _formatting = require("../../../../common/formatting");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _table = require("../../table");
var _status_icon = require("../ml_job_listing/status_icon");
var _cluster_status = require("../cluster_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchMLJobs = ({
  clusterStatus,
  jobs,
  sorting,
  pagination,
  onTableChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_cluster_status.ClusterStatus, {
    stats: clusterStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, null, /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
    className: "mlJobsTable",
    rows: jobs,
    columns: columns,
    sorting: {
      ...sorting,
      sort: {
        ...sorting.sort,
        field: 'job_id'
      }
    },
    pagination: pagination,
    message: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.noJobsDescription', {
      defaultMessage: 'There are no Machine Learning Jobs that match your query. Try changing the time range selection.'
    }),
    search: {
      box: {
        incremental: true,
        placeholder: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.filterJobsPlaceholder', {
          defaultMessage: 'Filter Jobs…'
        })
      }
    },
    onTableChange: onTableChange,
    executeQueryOptions: {
      defaultFields: ['job_id']
    }
  }))));
};
exports.ElasticsearchMLJobs = ElasticsearchMLJobs;
const columns = [{
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.jobIdTitle', {
    defaultMessage: 'Job ID'
  }),
  field: 'job_id',
  sortable: true
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.stateTitle', {
    defaultMessage: 'State'
  }),
  field: 'state',
  sortable: true,
  render: state => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_status_icon.MachineLearningJobStatusIcon, {
    status: state
  }), "\xA0", (0, _lodash.capitalize)(state))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.processedRecordsTitle', {
    defaultMessage: 'Processed Records'
  }),
  field: 'data_counts.processed_record_count',
  sortable: true,
  render: value => /*#__PURE__*/_react.default.createElement("span", null, (0, _numeral.default)(value).format(_formatting.LARGE_ABBREVIATED))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.modelSizeTitle', {
    defaultMessage: 'Model Size'
  }),
  field: 'model_size_stats.model_bytes',
  sortable: true,
  render: value => /*#__PURE__*/_react.default.createElement("span", null, (0, _numeral.default)(value).format(_formatting.LARGE_BYTES))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.forecastsTitle', {
    defaultMessage: 'Forecasts'
  }),
  field: 'forecasts_stats.total',
  sortable: true,
  render: value => /*#__PURE__*/_react.default.createElement("span", null, (0, _numeral.default)(value).format(_formatting.LARGE_ABBREVIATED))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobListing.nodeTitle', {
    defaultMessage: 'Node'
  }),
  field: 'node.name',
  sortable: true,
  render: (name, job) => {
    if (job.node) {
      if ('id' in job.node) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/elasticsearch/nodes/${job.node.id}`)
        }, name);
      } else return /*#__PURE__*/_react.default.createElement("span", null, name);
    }
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.mlJobListing.noDataLabel",
      defaultMessage: "N/A"
    });
  }
}];