"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showAlertsToast = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _legacy_shims = require("../../legacy_shims");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const showApiKeyAndEncryptionError = theme$ => {
  const settingsUrl = _legacy_shims.Legacy.shims.docLinks.links.alerting.generalSettings;
  _legacy_shims.Legacy.shims.toastNotifications.addWarning({
    title: _i18n.i18n.translate('xpack.monitoring.healthCheck.tlsAndEncryptionErrorTitle', {
      defaultMessage: 'Additional setup required'
    }),
    text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.healthCheck.tlsAndEncryptionError', {
      defaultMessage: 'Stack Monitoring rules require API keys to be enabled and an encryption key to be configured.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: settingsUrl,
      external: true,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.monitoring.healthCheck.encryptionErrorAction', {
      defaultMessage: 'Learn how.'
    }))), {
      theme$
    })
  });
};
const showUnableToDisableWatcherClusterAlertsError = theme$ => {
  const settingsUrl = _legacy_shims.Legacy.shims.docLinks.links.alerting.generalSettings;
  _legacy_shims.Legacy.shims.toastNotifications.addWarning({
    title: _i18n.i18n.translate('xpack.monitoring.healthCheck.unableToDisableWatches.title', {
      defaultMessage: 'Legacy cluster alerts still active'
    }),
    text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.healthCheck.unableToDisableWatches.text', {
      defaultMessage: 'We failed to remove legacy cluster alerts. Please check the Kibana server log for more details, or try again later.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: settingsUrl,
      external: true,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.monitoring.healthCheck.unableToDisableWatches.action', {
      defaultMessage: 'Learn more.'
    }))), {
      theme$
    })
  });
};
const showDisabledWatcherClusterAlertsError = () => {
  _legacy_shims.Legacy.shims.toastNotifications.addWarning({
    title: _i18n.i18n.translate('xpack.monitoring.healthCheck.disabledWatches.title', {
      defaultMessage: 'New alerts created'
    }),
    text: _i18n.i18n.translate('xpack.monitoring.healthCheck.disabledWatches.text', {
      defaultMessage: 'Review the alert definition using Setup mode and configure additional action connectors to get notified via your favorite method.'
    }),
    'data-test-subj': 'alertsCreatedToast'
  });
};
const showAlertsToast = (response, theme$) => {
  const {
    isSufficientlySecure,
    hasPermanentEncryptionKey,
    disabledWatcherClusterAlerts
  } = response;
  if (isSufficientlySecure === false || hasPermanentEncryptionKey === false) {
    showApiKeyAndEncryptionError(theme$);
  } else if (disabledWatcherClusterAlerts === false) {
    showUnableToDisableWatcherClusterAlertsError(theme$);
  } else if (disabledWatcherClusterAlerts === true) {
    showDisabledWatcherClusterAlertsError();
  }
};
exports.showAlertsToast = showAlertsToast;