"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableAlertsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _legacy_shims = require("../legacy_shims");
var _use_alerts_modal = require("../application/hooks/use_alerts_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnableAlertsModal = ({
  alerts
}) => {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const alertsEnableModalProvider = (0, _use_alerts_modal.useAlertsModal)();
  const closeModal = () => {
    setIsModalVisible(false);
    alertsEnableModalProvider.hideModalForSession();
  };
  const radios = [{
    id: 'create-alerts',
    label: _i18n.i18n.translate('xpack.monitoring.alerts.modal.yesOption', {
      defaultMessage: 'Yes (Recommended - create default rules in this kibana space)'
    })
  }, {
    id: 'not-create-alerts',
    label: _i18n.i18n.translate('xpack.monitoring.alerts.modal.noOption', {
      defaultMessage: 'No'
    })
  }];
  const [radioIdSelected, setRadioIdSelected] = (0, _react.useState)('create-alerts');
  const onChange = optionId => {
    setRadioIdSelected(optionId);
  };
  (0, _react.useEffect)(() => {
    if (alertsEnableModalProvider.shouldShowAlertsModal(alerts)) {
      setIsModalVisible(true);
    }
  }, [alertsEnableModalProvider, alerts]);
  const confirmButtonClick = () => {
    if (radioIdSelected === 'create-alerts') {
      alertsEnableModalProvider.enableAlerts();
    } else {
      alertsEnableModalProvider.notAskAgain();
    }
    closeModal();
  };
  const remindLaterClick = () => {
    alertsEnableModalProvider.hideModalForSession();
    closeModal();
  };
  return isModalVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.title",
    defaultMessage: "Create rules"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.description",
    defaultMessage: "Stack monitoring comes with many out-of-the box rules to notify you of common issues around cluster health, resource utilization and errors or exceptions. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _legacy_shims.Legacy.shims.docLinks.links.monitoring.alertsKibana,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.alerts.modal.description.link",
        defaultMessage: "Learn more..."
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.createDescription",
    defaultMessage: "Create these out-of-the box rules?"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: radios,
    idSelected: radioIdSelected,
    onChange: id => onChange(id),
    name: "radio group"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: remindLaterClick,
    "data-test-subj": "alerts-modal-remind-later-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.remindLater",
    defaultMessage: "Remind me later"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: confirmButtonClick,
    fill: true,
    "data-test-subj": "alerts-modal-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.modal.confirm",
    defaultMessage: "Ok"
  })))) : null;
};
exports.EnableAlertsModal = EnableAlertsModal;