"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkerProxyService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _monaco_imports = require("../monaco_imports");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class WorkerProxyService {
  constructor() {
    (0, _defineProperty2.default)(this, "worker", void 0);
  }
  async getAnnos(modelUri) {
    if (!this.worker) {
      throw new Error('Worker Proxy Service has not been setup!');
    }
    await this.worker.withSyncedResources([modelUri]);
    const proxy = await this.worker.getProxy();
    return proxy.parse(modelUri.toString());
  }
  setup() {
    this.worker = _monaco_imports.monaco.editor.createWebWorker({
      label: _constants.ID,
      moduleId: ''
    });
  }
  stop() {
    if (this.worker) this.worker.dispose();
  }
}
exports.WorkerProxyService = WorkerProxyService;