"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildSourcesDefinitions = exports.buildNewVarDefinition = exports.buildFieldsDefinitions = exports.buildConstantsDefinitions = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildFieldsDefinitions = fields => fields.map(label => ({
  label,
  insertText: label,
  kind: 4,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.fieldDefinition', {
    defaultMessage: `Field specified by the input table`
  }),
  sortText: 'D'
}));
exports.buildFieldsDefinitions = buildFieldsDefinitions;
const buildNewVarDefinition = label => {
  return {
    label,
    insertText: label,
    kind: 21,
    detail: _i18n.i18n.translate('monaco.esql.autocomplete.newVarDoc', {
      defaultMessage: 'Define a new variable'
    }),
    sortText: 'D'
  };
};
exports.buildNewVarDefinition = buildNewVarDefinition;
const buildSourcesDefinitions = sources => sources.map(label => ({
  label,
  insertText: label,
  kind: 21,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.sourceDefinition', {
    defaultMessage: `Input table`
  }),
  sortText: 'A'
}));
exports.buildSourcesDefinitions = buildSourcesDefinitions;
const buildConstantsDefinitions = (userConstants, detail) => userConstants.map(label => ({
  label,
  insertText: label,
  kind: 14,
  detail: detail !== null && detail !== void 0 ? detail : _i18n.i18n.translate('monaco.esql.autocomplete.constantDefinition', {
    defaultMessage: `User defined variable`
  }),
  sortText: 'A'
}));
exports.buildConstantsDefinitions = buildConstantsDefinitions;