"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRAINED_MODEL_TYPE = exports.SUPPORTED_PYTORCH_TASKS = exports.MODEL_STATE = exports.ELASTIC_MODEL_TYPE = exports.ELASTIC_MODEL_TAG = exports.ELASTIC_MODEL_DEFINITIONS = exports.DEPLOYMENT_STATE = exports.BUILT_IN_MODEL_TYPE = exports.BUILT_IN_MODEL_TAG = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEPLOYMENT_STATE = {
  STARTED: 'started',
  STARTING: 'starting',
  STOPPING: 'stopping'
};
exports.DEPLOYMENT_STATE = DEPLOYMENT_STATE;
const TRAINED_MODEL_TYPE = {
  PYTORCH: 'pytorch',
  TREE_ENSEMBLE: 'tree_ensemble',
  LANG_IDENT: 'lang_ident'
};
exports.TRAINED_MODEL_TYPE = TRAINED_MODEL_TYPE;
const SUPPORTED_PYTORCH_TASKS = {
  NER: 'ner',
  QUESTION_ANSWERING: 'question_answering',
  ZERO_SHOT_CLASSIFICATION: 'zero_shot_classification',
  TEXT_CLASSIFICATION: 'text_classification',
  TEXT_EMBEDDING: 'text_embedding',
  FILL_MASK: 'fill_mask',
  // Not supported yet by the Trained Models UI
  TEXT_EXPANSION: 'text_expansion'
};
exports.SUPPORTED_PYTORCH_TASKS = SUPPORTED_PYTORCH_TASKS;
const BUILT_IN_MODEL_TYPE = _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.builtInModelLabel', {
  defaultMessage: 'built-in'
});
exports.BUILT_IN_MODEL_TYPE = BUILT_IN_MODEL_TYPE;
const ELASTIC_MODEL_TYPE = 'elastic';
exports.ELASTIC_MODEL_TYPE = ELASTIC_MODEL_TYPE;
const BUILT_IN_MODEL_TAG = 'prepackaged';
exports.BUILT_IN_MODEL_TAG = BUILT_IN_MODEL_TAG;
const ELASTIC_MODEL_TAG = 'elastic';
exports.ELASTIC_MODEL_TAG = ELASTIC_MODEL_TAG;
const ELASTIC_MODEL_DEFINITIONS = {
  '.elser_model_1': {
    config: {
      input: {
        field_names: ['text_field']
      }
    },
    description: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.elserDescription', {
      defaultMessage: 'Elastic Learned Sparse EncodeR v1 (Tech Preview)'
    })
  }
};
exports.ELASTIC_MODEL_DEFINITIONS = ELASTIC_MODEL_DEFINITIONS;
const MODEL_STATE = {
  ...DEPLOYMENT_STATE,
  DOWNLOADING: 'downloading',
  DOWNLOADED: 'downloaded'
};
exports.MODEL_STATE = MODEL_STATE;