"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EmbeddableAnomalyChartsContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _use_embeddable_execution_context = require("../common/use_embeddable_execution_context");
var _use_anomaly_charts_input_resolver = require("./use_anomaly_charts_input_resolver");
var _explorer_anomalies_container = require("../../application/explorer/explorer_charts/explorer_anomalies_container");
var _locator = require("../../../common/constants/locator");
var _select_severity = require("../../application/components/controls/select_severity/select_severity");
var _time_buckets = require("../../application/util/time_buckets");
var _triggers = require("../../ui_actions/triggers");
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESIZE_THROTTLE_TIME_MS = 500;
const EmbeddableAnomalyChartsContainer = ({
  id,
  embeddableContext,
  embeddableInput,
  services,
  refresh,
  onInputChange,
  onOutputChange,
  onRenderComplete,
  onError,
  onLoading
}) => {
  var _embeddableContext$ge;
  (0, _use_embeddable_execution_context.useEmbeddableExecutionContext)(services[0].executionContext, embeddableInput, _.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE, id);
  const [chartWidth, setChartWidth] = (0, _react.useState)(0);
  const [severity, setSeverity] = (0, _react.useState)((0, _select_severity.optionValueToThreshold)((_embeddableContext$ge = embeddableContext.getInput().severityThreshold) !== null && _embeddableContext$ge !== void 0 ? _embeddableContext$ge : _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING));
  const [selectedEntities, setSelectedEntities] = (0, _react.useState)();
  const [{
    uiSettings
  }, {
    data: dataServices,
    share,
    uiActions,
    charts: chartsService
  }] = services;
  const {
    timefilter
  } = dataServices.query.timefilter;
  const mlLocator = (0, _react.useMemo)(() => share.url.locators.get(_locator.ML_APP_LOCATOR), [share]);
  const timeBuckets = (0, _react.useMemo)(() => {
    return new _time_buckets.TimeBuckets({
      'histogram:maxBars': uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      'histogram:barTarget': uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
      dateFormat: uiSettings.get('dateFormat'),
      'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const input = (0, _useObservable.default)(embeddableInput);
  (0, _react.useEffect)(() => {
    onInputChange({
      severityThreshold: severity.val
    });
    onOutputChange({
      severity: severity.val,
      entityFields: selectedEntities
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [severity, selectedEntities]);
  const {
    chartsData,
    isLoading: isExplorerLoading,
    error
  } = (0, _use_anomaly_charts_input_resolver.useAnomalyChartsInputResolver)(embeddableInput, onInputChange, refresh, services, chartWidth, severity.val, {
    onRenderComplete,
    onError,
    onLoading
  });

  // Holds the container height for previously fetched data
  const containerHeightRef = (0, _react.useRef)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const resizeHandler = (0, _react.useCallback)((0, _lodash.throttle)(e => {
    // Keep previous container height so it doesn't change the page layout
    if (!isExplorerLoading) {
      containerHeightRef.current = e.height;
    }
    if (Math.abs(chartWidth - e.width) > 20) {
      setChartWidth(e.width);
    }
  }, RESIZE_THROTTLE_TIME_MS), [!isExplorerLoading, chartWidth]);
  const containerHeight = (0, _react.useMemo)(() => {
    // Persists container height during loading to prevent page from jumping
    return isExplorerLoading ? containerHeightRef.current : undefined;
  }, [isExplorerLoading]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomalyChartsEmbeddable.errorMessage",
        defaultMessage: "Unable to load the ML anomaly explorer data"
      }),
      color: "danger",
      iconType: "warning",
      style: {
        width: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement("p", null, error.message));
  }
  const addEntityFieldFilter = (fieldName, fieldValue, operation) => {
    const entity = {
      fieldName,
      fieldValue,
      operation
    };
    const uniqueSelectedEntities = [entity];
    setSelectedEntities(uniqueSelectedEntities);
    uiActions.getTrigger(_triggers.EXPLORER_ENTITY_FIELD_SELECTION_TRIGGER).exec({
      embeddable: embeddableContext,
      data: uniqueSelectedEntities
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: resizeHandler
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    id: `mlAnomalyExplorerEmbeddableWrapper-${id}`,
    style: {
      width: '100%',
      overflowY: 'auto',
      overflowX: 'hidden',
      padding: '8px',
      height: containerHeight
    },
    "data-test-subj": `mlExplorerEmbeddable_${embeddableContext.id}`,
    ref: resizeRef
  }, isExplorerLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: 'center',
    style: {
      position: 'absolute',
      top: '50%',
      left: '50%',
      transform: 'translate(-50%,-50%)'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl",
    mono: true,
    "data-test-subj": "mlAnomalyExplorerEmbeddableLoadingIndicator"
  })), chartsData !== undefined && isExplorerLoading === false && /*#__PURE__*/_react.default.createElement(_explorer_anomalies_container.ExplorerAnomaliesContainer, {
    id: id,
    showCharts: true,
    chartsData: chartsData,
    severity: severity,
    setSeverity: setSeverity,
    mlLocator: mlLocator,
    timeBuckets: timeBuckets,
    timefilter: timefilter,
    onSelectEntity: addEntityFieldFilter,
    showSelectedInterval: false,
    chartsService: chartsService,
    timeRange: input === null || input === void 0 ? void 0 : input.timeRange
  })));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.EmbeddableAnomalyChartsContainer = EmbeddableAnomalyChartsContainer;
var _default = EmbeddableAnomalyChartsContainer;
exports.default = _default;