"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultExplorerChartsPanelTitle = exports.AnomalyChartsEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _embeddable_anomaly_charts_container_lazy = require("./embeddable_anomaly_charts_container_lazy");
var _ = require("..");
var _embeddable_loading_fallback = require("../common/components/embeddable_loading_fallback");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultExplorerChartsPanelTitle = jobIds => _i18n.i18n.translate('xpack.ml.anomalyChartsEmbeddable.title', {
  defaultMessage: 'ML anomaly charts for {jobIds}',
  values: {
    jobIds: jobIds.join(', ')
  }
});
exports.getDefaultExplorerChartsPanelTitle = getDefaultExplorerChartsPanelTitle;
class AnomalyChartsEmbeddable extends _public2.Embeddable {
  constructor(initialInput, services, parent) {
    super(initialInput, {
      defaultTitle: initialInput.title,
      defaultDescription: initialInput.description
    }, parent);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "type", _.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE);
    this.services = services;
    this.initializeOutput(initialInput);
  }
  async initializeOutput(initialInput) {
    const {
      anomalyExplorerService
    } = this.services[2];
    const {
      jobIds
    } = initialInput;
    try {
      const jobs = await anomalyExplorerService.getCombinedJobs(jobIds);
      const dataViewsService = this.services[1].data.dataViews;

      // First get list of unique indices from the selected jobs
      const indices = new Set(jobs.map(j => j.datafeed_config.indices).flat());
      // Then find the data view assuming the data view title matches the index name
      const indexPatterns = {};
      for (const indexName of indices) {
        const response = await dataViewsService.find(`"${indexName}"`);
        const indexPattern = response.find(obj => obj.title.toLowerCase() === indexName.toLowerCase());
        if (indexPattern !== undefined) {
          indexPatterns[indexPattern.id] = indexPattern;
        }
      }
      this.updateOutput({
        ...this.getOutput(),
        indexPatterns: Object.values(indexPatterns)
      });
    } catch (e) {
      // Unable to find and load data view but we can ignore the error
      // as we only load it to support the filter & query bar
      // the visualizations should still work correctly

      // eslint-disable-next-line no-console
      console.error(`Unable to load data views for ${jobIds}`, e);
    }
  }
  onLoading() {
    this.renderComplete.dispatchInProgress();
    this.updateOutput({
      loading: true,
      error: undefined
    });
  }
  onError(error) {
    this.renderComplete.dispatchError();
    this.updateOutput({
      loading: false,
      error: {
        name: error.name,
        message: error.message
      }
    });
  }
  onRenderComplete() {
    this.renderComplete.dispatchComplete();
    this.updateOutput({
      loading: false,
      error: undefined
    });
  }
  render(node) {
    super.render(node);
    this.node = node;

    // required for the export feature to work
    this.node.setAttribute('data-shared-item', '');
    const I18nContext = this.services[0].i18n.Context;
    const theme$ = this.services[0].theme.theme$;
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...this.services[0]
      }
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_embeddable_loading_fallback.EmbeddableLoading, null)
    }, /*#__PURE__*/_react.default.createElement(_embeddable_anomaly_charts_container_lazy.EmbeddableAnomalyChartsContainer, {
      id: this.input.id,
      embeddableContext: this,
      embeddableInput: this.getInput$(),
      services: this.services,
      refresh: this.reload$.asObservable(),
      onInputChange: this.updateInput.bind(this),
      onOutputChange: this.updateOutput.bind(this),
      onRenderComplete: this.onRenderComplete.bind(this),
      onLoading: this.onLoading.bind(this),
      onError: this.onError.bind(this)
    }))))), node);
  }
  destroy() {
    super.destroy();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  reload() {
    this.reload$.next();
  }
  supportedTriggers() {
    return [];
  }
}
exports.AnomalyChartsEmbeddable = AnomalyChartsEmbeddable;