"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CalendarsListUI = exports.CalendarsList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _header = require("./header");
var _table = require("./table");
var _ml_api_service = require("../../../services/ml_api_service");
var _check_ml_nodes = require("../../../ml_nodes_check/check_ml_nodes");
var _delete_calendars = require("./delete_calendars");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _dependency_cache = require("../../../util/dependency_cache");
var _help_menu = require("../../../components/help_menu");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CalendarsListUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "loadCalendars", async () => {
      this.setState({
        loading: true
      });
      try {
        const calendars = await _ml_api_service.ml.calendars();
        this.setState({
          calendars,
          loading: false,
          isDestroyModalVisible: false
        });
      } catch (error) {
        console.log(error);
        this.setState({
          loading: false
        });
        const {
          toasts
        } = this.props.kibana.services.notifications;
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.calendarsList.errorWithLoadingListOfCalendarsErrorMessage', {
          defaultMessage: 'An error occurred loading the list of calendars.'
        }));
      }
    });
    (0, _defineProperty2.default)(this, "closeDestroyModal", () => {
      this.setState({
        isDestroyModalVisible: false,
        calendarId: null
      });
    });
    (0, _defineProperty2.default)(this, "showDestroyModal", () => {
      this.setState({
        isDestroyModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "setSelectedCalendarList", selectedCalendars => {
      this.setState({
        selectedForDeletion: selectedCalendars
      });
    });
    (0, _defineProperty2.default)(this, "deleteCalendars", () => {
      const {
        selectedForDeletion
      } = this.state;
      this.closeDestroyModal();
      (0, _delete_calendars.deleteCalendars)(selectedForDeletion, this.loadCalendars);
    });
    (0, _defineProperty2.default)(this, "addRequiredFieldsToList", (calendarsList = []) => {
      for (let i = 0; i < calendarsList.length; i++) {
        calendarsList[i].job_ids_string = calendarsList[i].job_ids.join(', ');
        calendarsList[i].events_length = calendarsList[i].events.length;
      }
      return calendarsList;
    });
    this.state = {
      loading: true,
      calendars: [],
      isDestroyModalVisible: false,
      calendarId: null,
      selectedForDeletion: [],
      nodesAvailable: (0, _check_ml_nodes.mlNodesAvailable)()
    };
  }
  componentDidMount() {
    this.loadCalendars();
  }
  render() {
    const {
      calendars,
      selectedForDeletion,
      loading,
      nodesAvailable
    } = this.state;
    const {
      canCreateCalendar,
      canDeleteCalendar
    } = this.props;
    let destroyModal = '';
    const helpLink = (0, _dependency_cache.getDocLinks)().links.ml.calendars;
    if (this.state.isDestroyModalVisible) {
      destroyModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "data-test-subj": 'mlCalendarDeleteConfirmation',
        title: _i18n.i18n.translate('xpack.ml.calendarsList.deleteCalendarsModal.deleteMultipleCalendarsTitle', {
          defaultMessage: 'Delete {calendarsCount, plural, one {{calendarsList}} other {# calendars}}?',
          values: {
            calendarsCount: selectedForDeletion.length,
            calendarsList: selectedForDeletion.map(c => c.calendar_id).join(', ')
          }
        }),
        onCancel: this.closeDestroyModal,
        onConfirm: this.deleteCalendars,
        cancelButtonText: _i18n.i18n.translate('xpack.ml.calendarsList.deleteCalendarsModal.cancelButtonLabel', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.ml.calendarsList.deleteCalendarsModal.deleteButtonLabel', {
          defaultMessage: 'Delete'
        }),
        buttonColor: "danger",
        defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlPageCalendarManagement"
    }, /*#__PURE__*/_react.default.createElement(_header.CalendarsListHeader, {
      totalCount: calendars.length,
      refreshCalendars: this.loadCalendars
    }), /*#__PURE__*/_react.default.createElement(_table.CalendarsListTable, {
      loading: loading,
      calendarsList: this.addRequiredFieldsToList(calendars),
      onDeleteClick: this.showDestroyModal,
      canCreateCalendar: canCreateCalendar,
      canDeleteCalendar: canDeleteCalendar,
      mlNodesAvailable: nodesAvailable,
      setSelectedCalendarList: this.setSelectedCalendarList,
      itemsSelected: selectedForDeletion.length > 0
    }), destroyModal), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
      docLink: helpLink
    }));
  }
}
exports.CalendarsListUI = CalendarsListUI;
(0, _defineProperty2.default)(CalendarsListUI, "propTypes", {
  canCreateCalendar: _propTypes.PropTypes.bool.isRequired,
  canDeleteCalendar: _propTypes.PropTypes.bool.isRequired
});
const CalendarsList = (0, _public.withKibana)(CalendarsListUI);
exports.CalendarsList = CalendarsList;