"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationsRouteFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _locator = require("../../../locator");
var _router = require("../router");
var _use_resolver = require("../use_resolver");
var _ml_nodes_check = require("../../ml_nodes_check");
var _ml_server_info = require("../../services/ml_server_info");
var _breadcrumbs = require("../breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const NotificationsPage = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../notifications/page'))));
const notificationsRouteFactory = (navigateToPath, basePath) => ({
  id: 'notifications',
  path: (0, _router.createPath)(_locator.ML_PAGES.NOTIFICATIONS),
  title: _i18n.i18n.translate('xpack.ml.notifications.notificationsLabel', {
    defaultMessage: 'Notifications'
  }),
  enableDatePicker: true,
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.overview.notificationsLabel', {
      defaultMessage: 'Notifications'
    })
  }],
  'data-test-subj': 'mlPageNotifications'
});
exports.notificationsRouteFactory = notificationsRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], {
    getMlNodeCount: _ml_nodes_check.getMlNodeCount,
    loadMlServerInfo: _ml_server_info.loadMlServerInfo
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(NotificationsPage, null)));
};