"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromMapRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _queryString = require("query-string");
var _kibana = require("../../../contexts/kibana");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _job_from_map = require("../../../jobs/new_job/job_from_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fromMapRouteFactory = () => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_FROM_MAP),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: []
});
exports.fromMapRouteFactory = fromMapRouteFactory;
const PageWrapper = ({
  location
}) => {
  const {
    dashboard,
    dataViewId,
    embeddable,
    geoField,
    splitField,
    from,
    to,
    layer
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    services: {
      data: {
        query: {
          timefilter: {
            timefilter: timeFilter
          }
        }
      },
      share,
      uiSettings: kibanaConfig,
      mlServices: {
        mlApiServices
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canCreateJob'], {
    redirect: () => (0, _job_from_map.resolver)({
      mlApiServices,
      timeFilter,
      kibanaConfig,
      share
    }, dashboard, dataViewId, embeddable, geoField, splitField, from, to, layer)
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB)
  }));
};