"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logCategorizationRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/aiops-plugin/common");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _log_categorization = require("../../../aiops/log_categorization");
var _breadcrumbs = require("../../breadcrumbs");
var _ml = require("../../../contexts/ml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logCategorizationRouteFactory = (navigateToPath, basePath) => ({
  id: 'log_categorization',
  path: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION),
  title: _i18n.i18n.translate('xpack.ml.aiops.logCategorization.docTitle', {
    defaultMessage: 'Log Pattern Analysis'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.aiops.logCategorization.docTitle', {
      defaultMessage: 'Log Pattern Analysis'
    })
  }],
  disabled: !_common.AIOPS_ENABLED
});
exports.logCategorizationRouteFactory = logCategorizationRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canUseAiops']);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, null, /*#__PURE__*/_react.default.createElement(_log_categorization.LogCategorizationPage, null)));
};