"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryPreviewChart = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _common = require("@kbn/field-formats-plugin/common");
var _use_field_formatter = require("../../contexts/kibana/use_field_formatter");
var _memory_item_colors = require("../memory_item_colors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MemoryPreviewChart = ({
  memoryOverview
}) => {
  const bytesFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const groups = (0, _react.useMemo)(() => ({
    jvm: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.jvmHeapSIze', {
        defaultMessage: 'JVM heap size'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('jvm-heap-size')
    },
    trained_models: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsMemoryUsage', {
        defaultMessage: 'Trained models'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('trained-model')
    },
    anomaly_detection: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.adMemoryUsage', {
        defaultMessage: 'Anomaly detection jobs'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('anomaly-detector')
    },
    dfa_training: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.dfaMemoryUsage', {
        defaultMessage: 'Data frame analytics jobs'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('data-frame-analytics')
    },
    available: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.availableMemory', {
        defaultMessage: 'Estimated available memory'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('estimated-available-memory')
    }
  }), []);
  const chartData = [{
    x: 0,
    y: memoryOverview.trained_models.total,
    g: groups.trained_models.name
  }, {
    x: 0,
    y: memoryOverview.anomaly_detection.total,
    g: groups.anomaly_detection.name
  }, {
    x: 0,
    y: memoryOverview.dfa_training.total,
    g: groups.dfa_training.name
  }, {
    x: 0,
    y: memoryOverview.machine_memory.total - memoryOverview.machine_memory.jvm - memoryOverview.trained_models.total - memoryOverview.dfa_training.total - memoryOverview.anomaly_detection.total,
    g: groups.available.name
  }, {
    x: 0,
    y: memoryOverview.machine_memory.jvm,
    g: groups.jvm.name
  }];
  const barSeriesColorAccessor = ({
    specId,
    yAccessor,
    splitAccessors
  }) => {
    const group = splitAccessors.get('g');
    return Object.values(groups).find(v => v.name === group).color;
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: ['100%', 50]
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: ({
      value
    }) => _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.memoryBreakdown', {
      defaultMessage: 'Approximate memory breakdown'
    })
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings
  // TODO use the EUI charts theme see src/plugins/charts/public/services/theme/README.md
  , {
    rotation: 90
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "ml_memory",
    position: _charts.Position.Bottom,
    hide: true,
    tickFormat: d => bytesFormatter(d)
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "line_annotation",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: memoryOverview.ml_max_in_bytes,
      details: bytesFormatter(memoryOverview.ml_max_in_bytes),
      header: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.mlMaxMemory', {
        defaultMessage: 'Maximum memory permitted for ML native processes'
      })
    }],
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowDown",
      "aria-label": _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.mlMaxMemoryAriaLabel', {
        defaultMessage: 'Maximum memory permitted for ML native processes {bytes}',
        values: {
          bytes: bytesFormatter(memoryOverview.ml_max_in_bytes)
        }
      })
    }),
    markerPosition: _charts.Position.Top
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "bars",
    xScaleType: _charts.ScaleType.Linear,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    splitSeriesAccessors: ['g'],
    stackAccessors: ['x'],
    data: chartData,
    color: barSeriesColorAccessor
  }));
};
exports.MemoryPreviewChart = MemoryPreviewChart;