"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMemoryItemColor = getMemoryItemColor;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMemoryItemColor(typeIn) {
  switch (typeIn) {
    case 'anomaly-detector':
      return (0, _eui.euiPaletteWarm)(5)[1];
    case 'data-frame-analytics':
      return (0, _eui.euiPalettePositive)(5)[2];
    case 'trained-model':
      return (0, _eui.euiPaletteForTemperature)(5)[1];
    case 'estimated-available-memory':
      return (0, _eui.euiPaletteGray)(5)[0];
    case 'jvm-heap-size':
      return (0, _eui.euiPaletteComplimentary)(5)[4];
    default:
      return (0, _eui.euiPaletteGray)(5)[4];
  }
}