"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _kibana = require("../../../../contexts/kibana");
var _page_header = require("../../../../components/page_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Page = ({
  nextStepPath
}) => {
  const RESULTS_PER_PAGE = 20;
  const {
    uiSettings,
    http,
    savedObjectsManagement
  } = (0, _kibana.useMlKibana)().services;
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const onObjectSelection = (id, type) => {
    navigateToPath(`${nextStepPath}?${type === 'index-pattern' ? 'index' : 'savedSearchId'}=${encodeURIComponent(id)}`);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageSourceSelection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.selectDataViewOrSavedSearch",
    defaultMessage: "Select data view or saved search"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    key: "searchSavedObjectFinder",
    onChoose: onObjectSelection,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.notFoundLabel', {
      defaultMessage: 'No matching data views or saved searches found.'
    }),
    savedObjectMetaData: [{
      type: 'search',
      getIconForSavedObject: () => 'search',
      name: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.savedObjectType.search', {
        defaultMessage: 'Saved search'
      })
    }, {
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.ml.newJob.wizard.searchSelection.savedObjectType.dataView', {
        defaultMessage: 'Data view'
      }),
      defaultSearchField: 'name'
    }],
    fixedPageSize: RESULTS_PER_PAGE,
    services: {
      uiSettings,
      http,
      savedObjectsManagement
    }
  }))));
};
exports.Page = Page;