"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectorDescription = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _rare_view = require("./rare_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetectorDescription = ({
  detectorType
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [description, setDescription] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    const desc = createDetectorDescription(jobCreator, detectorType);
    setDescription(desc);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  if (description === null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareField.plainText.calloutTitle', {
      defaultMessage: 'Job summary'
    })
  }, /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, description)));
};
exports.DetectorDescription = DetectorDescription;
function createDetectorDescription(jobCreator, detectorType) {
  var _jobCreator$populatio, _jobCreator$splitFiel;
  if (jobCreator.rareField === null) {
    return null;
  }
  const rareFieldName = jobCreator.rareField.id;
  const populationFieldName = (_jobCreator$populatio = jobCreator.populationField) === null || _jobCreator$populatio === void 0 ? void 0 : _jobCreator$populatio.id;
  const splitFieldName = (_jobCreator$splitFiel = jobCreator.splitField) === null || _jobCreator$splitFiel === void 0 ? void 0 : _jobCreator$splitFiel.id;
  const rareSummary = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareField.plainText.rareSummary', {
    defaultMessage: 'Detects rare {rareFieldName} values.',
    values: {
      rareFieldName
    }
  });
  const rareSplitSummary = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareField.plainText.rareSplitSummary', {
    defaultMessage: 'For each {splitFieldName}, detects rare {rareFieldName} values.',
    values: {
      splitFieldName,
      rareFieldName
    }
  });
  const freqRarePopulationSummary = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareField.plainText.freqRarePopulationSummary', {
    defaultMessage: 'Detects {populationFieldName} values that frequently have rare {rareFieldName} values relative to the population.',
    values: {
      populationFieldName,
      rareFieldName
    }
  });
  const freqRareSplitPopulationSummary = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareField.plainText.freqRareSplitPopulationSummary', {
    defaultMessage: 'For each {splitFieldName}, detects {populationFieldName} values that frequently have rare {rareFieldName} values relative to the population.',
    values: {
      splitFieldName,
      populationFieldName,
      rareFieldName
    }
  });
  const rarePopulationSummary = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareField.plainText.rarePopulationSummary', {
    defaultMessage: 'Detects {populationFieldName} values that have rare {rareFieldName} values relative to the population.',
    values: {
      populationFieldName,
      rareFieldName
    }
  });
  const rareSplitPopulationSummary = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareField.plainText.rareSplitPopulationSummary', {
    defaultMessage: 'For each {splitFieldName}, detects {populationFieldName} values that have rare {rareFieldName} values relative to the population.',
    values: {
      splitFieldName,
      populationFieldName,
      rareFieldName
    }
  });
  if (detectorType === _rare_view.RARE_DETECTOR_TYPE.RARE) {
    return splitFieldName !== undefined ? rareSplitSummary : rareSummary;
  }
  if (detectorType === _rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION) {
    return splitFieldName !== undefined ? freqRareSplitPopulationSummary : freqRarePopulationSummary;
  }
  if (detectorType === _rare_view.RARE_DETECTOR_TYPE.RARE_POPULATION) {
    return splitFieldName !== undefined ? rareSplitPopulationSummary : rarePopulationSummary;
  }
  return null;
}