"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CalendarsSelection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _job_creator_context = require("../../../../../job_creator_context");
var _description = require("./description");
var _ml_api_service = require("../../../../../../../../../services/ml_api_service");
var _app = require("../../../../../../../../../../../common/constants/app");
var _kibana = require("../../../../../../../../../contexts/kibana");
var _calendars = require("../../../../../../../../../../../common/constants/calendars");
var _locator = require("../../../../../../../../../../../common/constants/locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CalendarsSelection = () => {
  const {
    services: {
      application: {
        getUrlForApp
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    jobCreator,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [selectedCalendars, setSelectedCalendars] = (0, _react.useState)(jobCreator.calendars);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const [options, setOptions] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  async function loadCalendars() {
    setIsLoading(true);
    const calendars = (await _ml_api_service.ml.calendars()).filter(c => c.job_ids.includes(_calendars.GLOBAL_CALENDAR) === false);
    setOptions(calendars.map(c => ({
      label: c.calendar_id,
      value: c
    })));
    setSelectedOptions(selectedCalendars.map(c => ({
      label: c.calendar_id,
      value: c
    })));
    setIsLoading(false);
  }
  (0, _react.useEffect)(() => {
    loadCalendars();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    jobCreator.calendars = selectedCalendars;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedCalendars.join()]);
  const comboBoxProps = {
    async: true,
    options,
    selectedOptions,
    isLoading,
    onChange: optionsIn => {
      setSelectedOptions(optionsIn);
      setSelectedCalendars(optionsIn.map(o => o.value));
    }
  };
  const manageCalendarsHref = getUrlForApp(_app.PLUGIN_ID, {
    path: _locator.ML_PAGES.CALENDARS_MANAGE
  });
  return /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, comboBoxProps, {
    "data-test-subj": "mlJobWizardComboBoxCalendars"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobDetailsStep.additionalSection.calendarsSelection.refreshCalendarsButtonLabel",
      defaultMessage: "Refresh calendars"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "refresh",
    color: "primary",
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.additionalSection.calendarsSelection.refreshCalendarsButtonLabel', {
      defaultMessage: 'Refresh calendars'
    }),
    onClick: loadCalendars
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: manageCalendarsHref,
    target: "_blank",
    external: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobDetailsStep.additionalSection.calendarsSelection.manageCalendarsButtonLabel",
    defaultMessage: "Manage calendars"
  }))));
};
exports.CalendarsSelection = CalendarsSelection;