"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetQueryButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _new_job_utils = require("../../../../../utils/new_job_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResetQueryButton = () => {
  const {
    jobCreator,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [confirmModalVisible, setConfirmModalVisible] = (0, _react.useState)(false);
  const [defaultQueryString] = (0, _react.useState)(JSON.stringify((0, _new_job_utils.getDefaultDatafeedQuery)(), null, 2));
  const closeModal = () => setConfirmModalVisible(false);
  const showModal = () => setConfirmModalVisible(true);
  function resetDatafeed() {
    jobCreator.query = (0, _new_job_utils.getDefaultDatafeedQuery)();
    jobCreatorUpdate();
    closeModal();
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, confirmModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.resetQueryConfirm.title', {
      defaultMessage: 'Reset datafeed query'
    }),
    onCancel: closeModal,
    onConfirm: resetDatafeed,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.resetQueryConfirm.cancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.resetQueryConfirm.confirm', {
      defaultMessage: 'Confirm'
    }),
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.resetQueryConfirm.description",
    defaultMessage: "Set the datafeed query to be the default."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "js",
    fontSize: "m",
    paddingSize: "s"
  }, defaultQueryString)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: showModal
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.resetQueryButton",
    defaultMessage: "Reset datafeed query to default"
  })));
};
exports.ResetQueryButton = ResetQueryButton;