"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDITOR_MODE = exports.DatafeedPreviewFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../job_creator_context");
var _datafeed_preview = require("./datafeed_preview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let EDITOR_MODE;
exports.EDITOR_MODE = EDITOR_MODE;
(function (EDITOR_MODE) {
  EDITOR_MODE[EDITOR_MODE["HIDDEN"] = 0] = "HIDDEN";
  EDITOR_MODE[EDITOR_MODE["READONLY"] = 1] = "READONLY";
  EDITOR_MODE[EDITOR_MODE["EDITABLE"] = 2] = "EDITABLE";
})(EDITOR_MODE || (exports.EDITOR_MODE = EDITOR_MODE = {}));
const DatafeedPreviewFlyout = ({
  isDisabled
}) => {
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  function toggleFlyout() {
    setShowFlyout(!showFlyout);
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(FlyoutButton, {
    onClick: toggleFlyout,
    isDisabled: isDisabled
  }), showFlyout === true && isDisabled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setShowFlyout(false),
    hideCloseButton: true,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_datafeed_preview.DatafeedPreview, {
    combinedJob: {
      ...jobCreator.jobConfig,
      datafeed_config: jobCreator.datafeedConfig
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => setShowFlyout(false),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedPreviewFlyout.closeButton",
    defaultMessage: "Close"
  })))))));
};
exports.DatafeedPreviewFlyout = DatafeedPreviewFlyout;
const FlyoutButton = ({
  isDisabled,
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClick,
    isDisabled: isDisabled,
    "data-test-subj": "mlJobWizardButtonPreviewJobJson"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedPreviewFlyout.showButton",
    defaultMessage: "Datafeed preview"
  }));
};