"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COMPATIBLE_VISUALIZATION = exports.COMPATIBLE_SPLIT_FIELD_TYPES = exports.COMPATIBLE_SERIES_TYPES = exports.COMPATIBLE_LAYER_TYPE = void 0;
exports.createDetectors = createDetectors;
exports.getChartInfoFromVisualization = getChartInfoFromVisualization;
exports.getJobsItemsFromEmbeddable = getJobsItemsFromEmbeddable;
exports.getMlFunction = getMlFunction;
exports.getVisTypeFactory = getVisTypeFactory;
exports.hasIncompatibleProperties = hasIncompatibleProperties;
exports.isCompatibleLayer = isCompatibleLayer;
exports.isCompatibleSplitFieldType = isCompatibleSplitFieldType;
exports.isCompatibleVisualizationType = isCompatibleVisualizationType;
exports.isDataLayer = isDataLayer;
exports.isTermsField = isTermsField;
exports.lensOperationToMlFunction = lensOperationToMlFunction;
exports.redirectToADJobWizards = redirectToADJobWizards;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/lens-plugin/public");
var _fieldTypes = require("@kbn/field-types");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _locator = require("../../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMPATIBLE_SERIES_TYPES = ['line', 'bar', 'bar_stacked', 'bar_percentage_stacked', 'bar_horizontal', 'bar_horizontal_stacked', 'area', 'area_stacked', 'area_percentage_stacked'];
exports.COMPATIBLE_SERIES_TYPES = COMPATIBLE_SERIES_TYPES;
const COMPATIBLE_LAYER_TYPE = _public.layerTypes.DATA;
exports.COMPATIBLE_LAYER_TYPE = COMPATIBLE_LAYER_TYPE;
const COMPATIBLE_VISUALIZATION = 'lnsXY';
exports.COMPATIBLE_VISUALIZATION = COMPATIBLE_VISUALIZATION;
const COMPATIBLE_SPLIT_FIELD_TYPES = [_fieldTypes.KBN_FIELD_TYPES.STRING, _fieldTypes.KBN_FIELD_TYPES.IP];
exports.COMPATIBLE_SPLIT_FIELD_TYPES = COMPATIBLE_SPLIT_FIELD_TYPES;
async function redirectToADJobWizards(embeddable, layerIndex, share, lens) {
  const {
    query,
    filters,
    to,
    from,
    vis
  } = await getJobsItemsFromEmbeddable(embeddable, lens);
  const locator = share.url.locators.get(_locator.ML_APP_LOCATOR);
  const url = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
    page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_FROM_LENS,
    pageState: {
      vis: vis,
      from,
      to,
      query,
      filters,
      layerIndex
    }
  }));
  window.open(url, '_blank');
}
async function getJobsItemsFromEmbeddable(embeddable, lens) {
  var _embeddable$parent;
  if (!lens) {
    throw Error(_i18n.i18n.translate('xpack.ml.newJob.fromLens.createJob.error.lensNotFound', {
      defaultMessage: 'Lens is not intialized'
    }));
  }
  const {
    filters,
    timeRange,
    ...input
  } = embeddable.getInput();
  const query = input.query === undefined ? {
    query: '',
    language: 'kuery'
  } : input.query;
  if (timeRange === undefined) {
    throw Error(_i18n.i18n.translate('xpack.ml.newJob.fromLens.createJob.error.noTimeRange', {
      defaultMessage: 'Time range not specified.'
    }));
  }
  const {
    to,
    from
  } = timeRange;
  const vis = embeddable.getSavedVis();
  if (vis === undefined) {
    throw Error(_i18n.i18n.translate('xpack.ml.newJob.fromLens.createJob.error.visNotFound', {
      defaultMessage: 'Visualization cannot be found.'
    }));
  }
  const chartInfo = await getChartInfoFromVisualization(lens, vis);
  const dashboard = ((_embeddable$parent = embeddable.parent) === null || _embeddable$parent === void 0 ? void 0 : _embeddable$parent.type) === 'dashboard' ? embeddable.parent : undefined;
  return {
    vis,
    chartInfo,
    from,
    to,
    query,
    filters,
    dashboard
  };
}
function lensOperationToMlFunction(operationType) {
  switch (operationType) {
    case 'average':
      return _mlAnomalyUtils.ML_JOB_AGGREGATION.MEAN;
    case 'count':
      return _mlAnomalyUtils.ML_JOB_AGGREGATION.COUNT;
    case 'max':
      return _mlAnomalyUtils.ML_JOB_AGGREGATION.MAX;
    case 'median':
      return _mlAnomalyUtils.ML_JOB_AGGREGATION.MEDIAN;
    case 'min':
      return _mlAnomalyUtils.ML_JOB_AGGREGATION.MIN;
    case 'sum':
      return _mlAnomalyUtils.ML_JOB_AGGREGATION.SUM;
    case 'unique_count':
      return _mlAnomalyUtils.ML_JOB_AGGREGATION.DISTINCT_COUNT;
    default:
      return null;
  }
}
function getMlFunction(operationType) {
  const func = lensOperationToMlFunction(operationType);
  if (func === null) {
    throw Error(_i18n.i18n.translate('xpack.ml.newJob.fromLens.createJob.error.incorrectFunction', {
      defaultMessage: 'Selected function {operationType} is not supported by anomaly detection detectors',
      values: {
        operationType
      }
    }));
  }
  return func;
}
async function getVisTypeFactory(lens) {
  const visTypes = await lens.getXyVisTypes();
  return layer => {
    var _type$icon;
    switch (layer.layerType) {
      case _public.layerTypes.DATA:
        const type = visTypes.find(t => t.id === layer.chartType);
        return {
          label: (type === null || type === void 0 ? void 0 : type.fullLabel) || (type === null || type === void 0 ? void 0 : type.label) || layer.layerType,
          icon: (_type$icon = type === null || type === void 0 ? void 0 : type.icon) !== null && _type$icon !== void 0 ? _type$icon : ''
        };
      case _public.layerTypes.ANNOTATIONS:
        // Annotation and Reference line layers are not displayed.
        // but for consistency leave the labels in, in case we decide
        // to display these layers in the future
        return {
          label: _i18n.i18n.translate('xpack.ml.newJob.fromLens.createJob.VisType.annotations', {
            defaultMessage: 'Annotations'
          }),
          icon: ''
        };
      case _public.layerTypes.REFERENCELINE:
        return {
          label: _i18n.i18n.translate('xpack.ml.newJob.fromLens.createJob.VisType.referenceLine', {
            defaultMessage: 'Reference line'
          }),
          icon: ''
        };
      default:
        return {
          label: layer.layerType,
          icon: ''
        };
    }
  };
}
async function isCompatibleVisualizationType(chartInfo) {
  return chartInfo.visualizationType === COMPATIBLE_VISUALIZATION && chartInfo.layers.some(l => l.layerType === _public.layerTypes.DATA && l.dataView !== undefined);
}
function isCompatibleLayer(layer) {
  return layer.layerType === COMPATIBLE_LAYER_TYPE && layer.chartType && COMPATIBLE_SERIES_TYPES.includes(layer.chartType);
}
function isDataLayer(layer) {
  return 'chartType' in layer;
}
function isTermsField(dimension) {
  return dimension.operation.type === 'terms';
}
function isCompatibleSplitFieldType(dimension) {
  return COMPATIBLE_SPLIT_FIELD_TYPES.includes(dimension.operation.dataType);
}
function hasIncompatibleProperties(dimension) {
  return dimension.operation.hasTimeShift || dimension.operation.filter;
}
function createDetectors(fields, splitField) {
  return fields.map(({
    operation
  }) => {
    var _operation$fields, _splitField$operation;
    const func = getMlFunction(operation.type);
    return {
      function: func,
      // don't use the source field if the detector is count
      ...(func === 'count' ? {} : {
        field_name: (_operation$fields = operation.fields) === null || _operation$fields === void 0 ? void 0 : _operation$fields[0]
      }),
      ...(splitField ? {
        partition_field_name: (_splitField$operation = splitField.operation.fields) === null || _splitField$operation === void 0 ? void 0 : _splitField$operation[0]
      } : {})
    };
  });
}
async function getChartInfoFromVisualization(lens, vis) {
  const chartInfo = await (await (await lens.stateHelperApi()).chartInfo).getChartInfo(vis);
  if (!chartInfo) {
    throw new Error('Cannot create job, chart info is undefined');
  }
  return chartInfo;
}