"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.explorerReducer = void 0;
var _explorer_charts_container_service = require("../../explorer_charts/explorer_charts_container_service");
var _explorer_constants = require("../../explorer_constants");
var _explorer_utils = require("../../explorer_utils");
var _clear_influencer_filter_settings = require("./clear_influencer_filter_settings");
var _job_selection_change = require("./job_selection_change");
var _state = require("./state");
var _set_kql_query_bar_placeholder = require("./set_kql_query_bar_placeholder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const explorerReducer = (state, nextAction) => {
  const {
    type,
    payload
  } = nextAction;
  let nextState;
  switch (type) {
    case _explorer_constants.EXPLORER_ACTION.CLEAR_EXPLORER_DATA:
      nextState = (0, _state.getExplorerDefaultState)();
      break;
    case _explorer_constants.EXPLORER_ACTION.CLEAR_INFLUENCER_FILTER_SETTINGS:
      nextState = (0, _clear_influencer_filter_settings.clearInfluencerFilterSettings)(state);
      break;
    case _explorer_constants.EXPLORER_ACTION.CLEAR_JOBS:
      nextState = {
        ...state,
        ...(0, _explorer_utils.getClearedSelectedAnomaliesState)(),
        loading: false,
        selectedJobs: []
      };
      break;
    case _explorer_constants.EXPLORER_ACTION.JOB_SELECTION_CHANGE:
      nextState = (0, _job_selection_change.jobSelectionChange)(state, payload);
      break;
    case _explorer_constants.EXPLORER_ACTION.SET_CHARTS_DATA_LOADING:
      nextState = {
        ...state,
        anomalyChartsDataLoading: true,
        chartsData: (0, _explorer_charts_container_service.getDefaultChartsData)()
      };
      break;
    case _explorer_constants.EXPLORER_ACTION.SET_EXPLORER_DATA:
      nextState = {
        ...state,
        ...payload
      };
      break;
    default:
      nextState = state;
  }
  if (nextState.selectedJobs === null) {
    return nextState;
  }
  return {
    ...nextState,
    ...(0, _set_kql_query_bar_placeholder.setKqlQueryBarPlaceholder)(nextState)
  };
};
exports.explorerReducer = explorerReducer;