"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSwimlaneToDashboardControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _search = require("../../../../common/constants/search");
var _anomaly_swimlane_embeddable = require("../../../embeddables/anomaly_swimlane/anomaly_swimlane_embeddable");
var _explorer_constants = require("../explorer_constants");
var _embeddables = require("../../../embeddables");
var _use_dashboards_table = require("./use_dashboards_table");
var _add_to_dashboard_controls = require("./add_to_dashboard_controls");
var _use_add_to_dashboard_actions = require("./use_add_to_dashboard_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultEmbeddablePanelConfig(jobIds, queryString) {
  return {
    title: (0, _anomaly_swimlane_embeddable.getDefaultSwimlanePanelTitle)(jobIds).concat(queryString ? `- ${queryString}` : ''),
    id: (0, _eui.htmlIdGenerator)()()
  };
}
/**
 * Component for attaching anomaly swim lane embeddable to dashboards.
 */
const AddSwimlaneToDashboardControl = ({
  onClose,
  jobIds,
  viewBy,
  queryString
}) => {
  const {
    dashboardItems,
    isLoading,
    search
  } = (0, _use_dashboards_table.useDashboardTable)();
  const [selectedSwimlane, setSelectedSwimlane] = (0, _react.useState)(_explorer_constants.SWIMLANE_TYPE.OVERALL);
  const getEmbeddableInput = (0, _react.useCallback)(() => {
    const config = getDefaultEmbeddablePanelConfig(jobIds, queryString);
    return {
      ...config,
      jobIds,
      swimlaneType: selectedSwimlane,
      ...(selectedSwimlane === _explorer_constants.SWIMLANE_TYPE.VIEW_BY ? {
        viewBy
      } : {}),
      ...(queryString !== undefined ? {
        query: {
          query: queryString,
          language: _search.SEARCH_QUERY_LANGUAGE.KUERY
        }
      } : {})
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedSwimlane]);
  const {
    addToDashboardAndEditCallback
  } = (0, _use_add_to_dashboard_actions.useAddToDashboardActions)(_embeddables.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE, getEmbeddableInput);
  const swimlaneTypeOptions = [{
    id: _explorer_constants.SWIMLANE_TYPE.OVERALL,
    label: _i18n.i18n.translate('xpack.ml.explorer.overallLabel', {
      defaultMessage: 'Overall'
    })
  }, {
    id: _explorer_constants.SWIMLANE_TYPE.VIEW_BY,
    label: _i18n.i18n.translate('xpack.ml.explorer.viewByFieldLabel', {
      defaultMessage: 'View by {viewByField}',
      values: {
        viewByField: viewBy
      }
    })
  }];
  const extraControls = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.addToDashboard.swimlanes.selectSwimlanesLabel",
      defaultMessage: "Select swim lane view:"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: swimlaneTypeOptions,
    idSelected: selectedSwimlane,
    onChange: optionId => {
      setSelectedSwimlane(optionId);
    },
    "data-test-subj": "mlAddToDashboardSwimlaneTypeSelector"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.addToDashboard.swimlanes.dashboardsTitle",
    defaultMessage: "Add swim lane to a dashboard"
  });
  return /*#__PURE__*/_react.default.createElement(_add_to_dashboard_controls.AddToDashboardControl, {
    onClose: onClose,
    dashboardItems: dashboardItems,
    isLoading: isLoading,
    search: search,
    addToDashboardAndEditCallback: addToDashboardAndEditCallback,
    disabled: false,
    title: title
  }, extraControls);
};
exports.AddSwimlaneToDashboardControl = AddSwimlaneToDashboardControl;