"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _anomaly_explorer_context = require("./anomaly_explorer_context");
var _string_utils = require("../util/string_utils");
var _search = require("../../../common/constants/search");
var _use_cases_modal = require("../contexts/kibana/use_cases_modal");
var _anomaly_explorer_charts_service = require("../services/anomaly_explorer_charts_service");
var _embeddables = require("../../embeddables");
var _kibana = require("../contexts/kibana");
var _explorer_utils = require("./explorer_utils");
var _add_anomaly_charts_to_dashboard_controls = require("./dashboard_controls/add_anomaly_charts_to_dashboard_controls");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalyContextMenu = ({
  selectedJobs,
  selectedCells,
  bounds,
  interval,
  chartsCount
}) => {
  var _capabilities$dashboa, _capabilities$dashboa2;
  const {
    services: {
      application: {
        capabilities
      },
      cases
    }
  } = (0, _kibana.useMlKibana)();
  const globalTimeRange = (0, _mlDatePicker.useTimeRangeUpdates)(true);
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const [isAddDashboardsActive, setIsAddDashboardActive] = (0, _react.useState)(false);
  const closePopoverOnAction = (0, _react.useCallback)(actionCallback => {
    setIsMenuOpen(false);
    actionCallback();
  }, [setIsMenuOpen]);
  const openCasesModal = (0, _use_cases_modal.useCasesModal)(_embeddables.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE);
  const canEditDashboards = (_capabilities$dashboa = (_capabilities$dashboa2 = capabilities.dashboard) === null || _capabilities$dashboa2 === void 0 ? void 0 : _capabilities$dashboa2.createNew) !== null && _capabilities$dashboa !== void 0 ? _capabilities$dashboa : false;
  const casesPrivileges = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases();
  const {
    anomalyExplorerCommonStateService,
    chartsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const {
    queryString
  } = (0, _useObservable.default)(anomalyExplorerCommonStateService.getFilterSettings$(), anomalyExplorerCommonStateService.getFilterSettings());
  const chartsData = (0, _useObservable.default)(chartsStateService.getChartsData$(), chartsStateService.getChartsData());
  const timeRangeToPlot = (0, _react.useMemo)(() => {
    if (chartsData.seriesToPlot.length > 0) {
      return {
        from: (0, _eui.formatDate)(chartsData.seriesToPlot[0].plotEarliest, 'MMM D, YYYY @ HH:mm:ss.SSS'),
        to: (0, _eui.formatDate)(chartsData.seriesToPlot[0].plotLatest, 'MMM D, YYYY @ HH:mm:ss.SSS')
      };
    }
    if (!!selectedCells && interval !== undefined && bounds !== undefined) {
      const {
        earliestMs,
        latestMs
      } = (0, _explorer_utils.getSelectionTimeRange)(selectedCells, bounds);
      return {
        from: (0, _eui.formatDate)(earliestMs, 'MMM D, YYYY @ HH:mm:ss.SSS'),
        to: (0, _eui.formatDate)(latestMs, 'MMM D, YYYY @ HH:mm:ss.SSS'),
        mode: 'absolute'
      };
    }
    return globalTimeRange;
  }, [chartsData.seriesToPlot, globalTimeRange, selectedCells, bounds, interval]);
  const menuItems = (0, _react.useMemo)(() => {
    const items = [];
    if (canEditDashboards) {
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "addToDashboard",
        onClick: closePopoverOnAction.bind(null, setIsAddDashboardActive.bind(null, true)),
        "data-test-subj": "mlAnomalyAddChartsToDashboardButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.explorer.anomalies.addToDashboardLabel",
        defaultMessage: "Add to dashboard"
      })));
    }
    if (!!(casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.create) || !!(casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.update)) {
      const selectionInfluencers = (0, _explorer_utils.getSelectionInfluencers)(selectedCells, selectedCells === null || selectedCells === void 0 ? void 0 : selectedCells.viewByFieldName);
      const queryFromSelectedCells = Array.isArray(selectionInfluencers) ? selectionInfluencers.map(s => (0, _string_utils.escapeKueryForFieldValuePair)(s.fieldName, s.fieldValue)).join(' or ') : '';
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "attachToCase",
        onClick: closePopoverOnAction.bind(null, openCasesModal.bind(null, {
          jobIds: selectedJobs === null || selectedJobs === void 0 ? void 0 : selectedJobs.map(v => v.id),
          timeRange: timeRangeToPlot,
          maxSeriesToPlot: _anomaly_explorer_charts_service.DEFAULT_MAX_SERIES_TO_PLOT,
          ...((0, _mlIsDefined.isDefined)(queryString) && queryString !== '' || queryFromSelectedCells !== '' ? {
            query: {
              query: queryString === '' ? queryFromSelectedCells : queryString,
              language: _search.SEARCH_QUERY_LANGUAGE.KUERY
            }
          } : {})
        })),
        "data-test-subj": "mlAnomalyAttachChartsToCasesButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.explorer.attachToCaseLabel",
        defaultMessage: "Add to case"
      })));
    }
    return items;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [canEditDashboards, globalTimeRange, closePopoverOnAction, selectedJobs, selectedCells, queryString, timeRangeToPlot]);
  const jobIds = selectedJobs.map(({
    id
  }) => id);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, menuItems.length > 0 && chartsCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginLeft: 'auto',
      alignSelf: 'baseline'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      "aria-label": _i18n.i18n.translate('xpack.ml.explorer.anomalies.actionsAriaLabel', {
        defaultMessage: 'Actions'
      }),
      color: "text",
      iconType: "boxesHorizontal",
      onClick: setIsMenuOpen.bind(null, !isMenuOpen),
      "data-test-subj": "mlExplorerAnomalyPanelMenu",
      disabled: chartsCount < 1
    }),
    isOpen: isMenuOpen,
    closePopover: setIsMenuOpen.bind(null, false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('xpack.ml.explorer.anomalies.actionsPopoverLabel', {
    defaultMessage: 'Anomaly charts'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems
  }))) : null, isAddDashboardsActive && selectedJobs ? /*#__PURE__*/_react.default.createElement(_add_anomaly_charts_to_dashboard_controls.AddAnomalyChartsToDashboardControl, {
    onClose: async () => {
      setIsAddDashboardActive(false);
    },
    jobIds: jobIds
  }) : null);
};
exports.AnomalyContextMenu = AnomalyContextMenu;