"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultExplorationPageUrlState = getDefaultExplorationPageUrlState;
exports.useExplorationUrlState = useExplorationUrlState;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlUrlState = require("@kbn/ml-url-state");
var _locator = require("../../../../../../common/constants/locator");
var _search = require("../../../../../../common/constants/search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultExplorationPageUrlState(overrides) {
  return {
    queryText: '',
    queryLanguage: _search.SEARCH_QUERY_LANGUAGE.KUERY,
    pageIndex: 0,
    pageSize: 25,
    analysis: false,
    evaluation: true,
    feature_importance: true,
    results: true,
    splom: true,
    ...((0, _mlIsPopulatedObject.isPopulatedObject)(overrides) ? overrides : {})
  };
}
function useExplorationUrlState(overrides) {
  return (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION, getDefaultExplorationPageUrlState(overrides));
}