"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureImportanceSummaryPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _kibana = require("../../../../../contexts/kibana");
var _expandable_section = require("../expandable_section");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  euiColorMediumShade
} = _uiTheme.euiLightVars;
const axisColor = euiColorMediumShade;
const axes = {
  axisLine: {
    stroke: axisColor
  },
  tickLabel: {
    fontSize: 12,
    fill: axisColor
  },
  tickLine: {
    stroke: axisColor
  },
  gridLine: {
    horizontal: {
      dash: [1, 2]
    },
    vertical: {
      strokeWidth: 0
    }
  }
};
const theme = {
  axes,
  legend: {
    /**
     * Added buffer between label and value.
     * Smaller values render a more compact legend
     */
    spacingBuffer: 100
  }
};
const tooltipContent = _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.featureImportanceSummaryTooltipContent', {
  defaultMessage: 'Total feature importance values indicate how significantly a field affects the predictions across all the training data.'
});
const calculateTotalMeanImportance = featureClass => {
  return featureClass.classes.reduce((runningSum, fc) => runningSum + fc.importance.mean_magnitude, 0);
};
const FeatureImportanceSummaryPanel = ({
  totalFeatureImportance,
  jobConfig
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const [plotData, barSeriesSpec, showLegend, chartHeight] = (0, _react.useMemo)(() => {
    let sortedData = [];
    let _barSeriesSpec = {
      xAccessor: 'featureName',
      yAccessors: ['meanImportance'],
      name: _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.featureImportanceYSeriesName', {
        defaultMessage: 'magnitude'
      })
    };
    let classificationType = '';
    if (totalFeatureImportance.length < 1) {
      return [sortedData, _barSeriesSpec, undefined, undefined];
    }
    if ((0, _mlDataFrameAnalyticsUtils.isClassificationTotalFeatureImportance)(totalFeatureImportance[0])) {
      // if binary classification
      if (totalFeatureImportance[0].classes.length === 2) {
        classificationType = 'binary_classification';
        sortedData = totalFeatureImportance.map(d => {
          return {
            featureName: d.feature_name,
            // in case of binary classification, both classes will have the same mean importance
            meanImportance: d.classes[0].importance.mean_magnitude
          };
        }).sort((a, b) => b.meanImportance - a.meanImportance);
      }

      // if multiclass classification
      // stack them in order of increasing importance
      // so for each feature, biggest importance on the left to smallest importance on the right
      if (totalFeatureImportance[0].classes.length > 2) {
        classificationType = 'multiclass_classification';
        totalFeatureImportance.sort((prevFeature, currentFeature) => calculateTotalMeanImportance(currentFeature) - calculateTotalMeanImportance(prevFeature)).forEach(feature => {
          const sortedFeatureClass = feature.classes.sort((a, b) => b.importance.mean_magnitude - a.importance.mean_magnitude);
          sortedData.push(...sortedFeatureClass.map(featureClass => ({
            featureName: feature.feature_name,
            meanImportance: featureClass.importance.mean_magnitude,
            className: featureClass.class_name
          })));
        });
        _barSeriesSpec = {
          xAccessor: 'featureName',
          yAccessors: ['meanImportance'],
          splitSeriesAccessors: ['className'],
          stackAccessors: ['featureName']
        };
      }
    }
    // if regression
    if ((0, _mlDataFrameAnalyticsUtils.isRegressionTotalFeatureImportance)(totalFeatureImportance[0])) {
      classificationType = 'regression';
      sortedData = totalFeatureImportance.map(d => ({
        featureName: d.feature_name,
        meanImportance: d.importance.mean_magnitude
      })).sort((a, b) => b.meanImportance - a.meanImportance);
    }

    // only show legend if it's a multiclass
    const _showLegend = classificationType === 'multiclass_classification';
    const _chartHeight = totalFeatureImportance.length * (totalFeatureImportance.length < 5 ? 40 : 20) + 50;
    return [sortedData, _barSeriesSpec, _showLegend, _chartHeight];
  }, [totalFeatureImportance]);
  const docLink = docLinks.links.ml.featureImportance;
  const tickFormatter = (0, _react.useCallback)(d => Number(d.toPrecision(3)).toString(), []);

  // do not expand by default if no feature importance data
  const noDataCallOut = (0, _react.useMemo)(() => {
    // if no total feature importance data
    if (totalFeatureImportance.length === 0) {
      // check if it's because num_top_feature_importance_values is set to 0
      if (jobConfig !== null && jobConfig !== void 0 && jobConfig.analysis && (0, _mlDataFrameAnalyticsUtils.isRegressionAnalysis)(jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis) || (0, _mlDataFrameAnalyticsUtils.isClassificationAnalysis)(jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis)) {
        const analysisType = (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(jobConfig.analysis);
        if (analysisType !== 'unknown' && jobConfig.analysis[analysisType].num_top_feature_importance_values === 0) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
            "data-test-subj": "mlTotalFeatureImportanceNotCalculatedCallout",
            size: "s",
            title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.ml.dataframe.analytics.exploration.totalFeatureImportanceNotCalculatedCalloutMessage",
              defaultMessage: "Feature importance was not calculated because num_top_feature_importance values is set to 0."
            })
          });
        } else {
          // or is it because the data is uniform
          return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
            "data-test-subj": "mlNoTotalFeatureImportanceCallout",
            size: "s",
            title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.ml.dataframe.analytics.exploration.noTotalFeatureImportanceCalloutMessage",
              defaultMessage: "Total feature importance data is not available; the data set is uniform and the features have no significant impact on the prediction."
            })
          });
        }
      }
    }
  }, [totalFeatureImportance, jobConfig]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    urlStateKey: 'feature_importance',
    isExpanded: noDataCallOut === undefined,
    dataTestId: "FeatureImportanceSummary",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.featureImportanceSummaryTitle",
      defaultMessage: "Total feature importance"
    }),
    docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      target: "_blank",
      iconType: "help",
      iconSide: "left",
      size: "xs",
      color: "primary",
      href: docLink
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.exploration.featureImportanceDocsLink",
      defaultMessage: "Feature importance docs"
    }))),
    headerItems: [{
      id: 'FeatureImportanceSummary',
      value: tooltipContent
    }],
    content: noDataCallOut ? noDataCallOut : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlTotalFeatureImportanceChart"
    }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
      size: {
        width: '100%',
        height: chartHeight
      }
    }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
      rotation: 90
      // TODO use the EUI charts theme see src/plugins/charts/public/services/theme/README.md
      ,
      theme: theme,
      showLegend: showLegend
    }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
      id: "x-axis",
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.featureImportanceXAxisTitle', {
        defaultMessage: 'Feature importance average magnitude'
      }),
      position: _charts.Position.Bottom,
      tickFormat: tickFormatter
    }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
      id: "y-axis",
      title: "",
      position: _charts.Position.Left
    }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, (0, _extends2.default)({
      id: "magnitude",
      xScaleType: _charts.ScaleType.Ordinal,
      yScaleType: _charts.ScaleType.Linear,
      data: plotData
    }, barSeriesSpec))))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.FeatureImportanceSummaryPanel = FeatureImportanceSummaryPanel;