"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfluencersList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _abbreviate_whole_number = require("../../formatters/abbreviate_whole_number");
var _entity_cell = require("../entity_cell");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering a list of Machine Learning influencers.
 */

function getTooltipContent(maxScoreLabel, totalScoreLabel) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.influencersList.maxAnomalyScoreTooltipDescription",
    defaultMessage: "Maximum anomaly score: {maxScoreLabel}",
    values: {
      maxScoreLabel
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.influencersList.totalAnomalyScoreTooltipDescription",
    defaultMessage: "Total anomaly score: {totalScoreLabel}",
    values: {
      totalScoreLabel
    }
  })));
}
const Influencer = ({
  influencerFieldName,
  influencerFilter,
  valueData
}) => {
  const maxScore = Math.floor(valueData.maxAnomalyScore);
  const maxScoreLabel = (0, _mlAnomalyUtils.getFormattedSeverityScore)(valueData.maxAnomalyScore);
  const severity = (0, _mlAnomalyUtils.getSeverity)(maxScore);
  const totalScore = Math.floor(valueData.sumAnomalyScore);
  const totalScoreLabel = (0, _mlAnomalyUtils.getFormattedSeverityScore)(valueData.sumAnomalyScore);

  // Ensure the bar has some width for 0 scores.
  const barScore = maxScore !== 0 ? maxScore : 1;
  const barStyle = {
    width: `${barScore}%`
  };
  const tooltipContent = getTooltipContent(maxScoreLabel, totalScoreLabel);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `mlInfluencerEntry field-${influencerFieldName}`
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "field-label",
    "data-test-subj": "mlInfluencerEntryFieldLabel"
  }, /*#__PURE__*/_react.default.createElement(_entity_cell.EntityCell, {
    entityName: influencerFieldName,
    entityValue: valueData.influencerFieldValue,
    filter: influencerFilter
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: `progress ${severity.id}`
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "progress-bar-holder"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "progress-bar",
    style: barStyle
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "score-label"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    className: "ml-influencers-list-tooltip",
    title: `${influencerFieldName}: ${valueData.influencerFieldValue}`,
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement("span", null, maxScoreLabel)))), /*#__PURE__*/_react.default.createElement("div", {
    className: "total-score-label"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    className: "ml-influencers-list-tooltip",
    title: `${influencerFieldName}: ${valueData.influencerFieldValue}`,
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement("span", null, totalScore > 0 ? (0, _abbreviate_whole_number.abbreviateWholeNumber)(totalScore, 4) : totalScoreLabel))));
};
const InfluencersByName = ({
  influencerFieldName,
  influencerFilter,
  fieldValues
}) => {
  const influencerValues = fieldValues.map(valueData => /*#__PURE__*/_react.default.createElement(Influencer, {
    key: valueData.influencerFieldValue,
    influencerFieldName: influencerFieldName,
    influencerFilter: influencerFilter,
    valueData: valueData
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: influencerFieldName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": `mlInfluencerFieldName ${influencerFieldName}`
  }, /*#__PURE__*/_react.default.createElement("h3", null, influencerFieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), influencerValues, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const InfluencersList = ({
  influencers,
  influencerFilter
}) => {
  if (influencers === undefined || Object.keys(influencers).length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      className: "ml-influencers-list"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      className: "influencer-title"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.influencersList.noInfluencersFoundTitle",
      defaultMessage: "No influencers found"
    })))));
  }
  const influencersByName = Object.keys(influencers).map(influencerFieldName => /*#__PURE__*/_react.default.createElement(InfluencersByName, {
    key: influencerFieldName,
    influencerFieldName: influencerFieldName,
    influencerFilter: influencerFilter,
    fieldValues: influencers[influencerFieldName]
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "ml-influencers-list"
  }, influencersByName);
};
exports.InfluencersList = InfluencersList;