"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFieldStatsTrigger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui_combo_box_with_field_stats = require("./eui_combo_box_with_field_stats");
var _ = require(".");
var _field_stats_info_button = require("./field_stats_info_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFieldStatsTrigger = () => {
  const {
    setIsFlyoutVisible,
    setFieldName
  } = (0, _.useFieldStatsFlyoutContext)();
  const closeFlyout = (0, _react.useCallback)(() => setIsFlyoutVisible(false), [setIsFlyoutVisible]);
  const handleFieldStatsButtonClick = (0, _react.useCallback)(field => {
    if (typeof field.id === 'string') {
      setFieldName(field.id);
      setIsFlyoutVisible(true);
    }
  }, [setFieldName, setIsFlyoutVisible]);
  const renderOption = (0, _react.useCallback)((option, searchValue) => {
    const field = option.field;
    return option.isGroupLabelOption || !field ? option.label : /*#__PURE__*/_react.default.createElement(_field_stats_info_button.FieldStatsInfoButton, {
      field: field,
      label: option.label,
      onButtonClick: handleFieldStatsButtonClick
    });
  }, [handleFieldStatsButtonClick]);
  return {
    renderOption,
    setIsFlyoutVisible,
    setFieldName,
    handleFieldStatsButtonClick,
    closeFlyout,
    optionCss: _eui_combo_box_with_field_stats.optionCss
  };
};
exports.useFieldStatsTrigger = useFieldStatsTrigger;