"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomUrls = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _custom_url_editor = require("./custom_url_editor");
var _utils = require("./custom_url_editor/utils");
var _edit_utils = require("../../jobs/jobs_list/components/edit_job_flyout/edit_utils");
var _custom_url_utils = require("../../util/custom_url_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CustomUrlsUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "editNewCustomUrl", () => {
      // Opens the editor for configuring a new custom URL.
      this.setState(prevState => {
        const {
          dashboards,
          dataViewListItems
        } = prevState;
        return {
          editorOpen: true,
          editorSettings: (0, _utils.getNewCustomUrlDefaults)(this.props.job, dashboards, dataViewListItems)
        };
      });
    });
    (0, _defineProperty2.default)(this, "setEditCustomUrl", customUrl => {
      this.setState({
        editorSettings: customUrl
      });
    });
    (0, _defineProperty2.default)(this, "addNewCustomUrl", () => {
      const {
        dashboard
      } = this.props.kibana.services;
      (0, _utils.buildCustomUrlFromSettings)(dashboard, this.state.editorSettings).then(customUrl => {
        const customUrls = [...this.state.customUrls, customUrl];
        this.props.setCustomUrls(customUrls);
        this.setState({
          editorOpen: false
        });
      }).catch(error => {
        // eslint-disable-next-line no-console
        console.error('Error building custom URL from settings:', error);
        const {
          toasts
        } = this.props.kibana.services.notifications;
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.addNewUrlErrorNotificationMessage', {
          defaultMessage: 'An error occurred building the new custom URL from the supplied settings'
        }));
      });
    });
    (0, _defineProperty2.default)(this, "onTestButtonClick", () => {
      var _this$state, _this$state$editorSet, _this$state$editorSet2;
      const {
        http: {
          basePath
        },
        notifications: {
          toasts
        },
        data: {
          dataViews
        },
        dashboard
      } = this.props.kibana.services;
      const dataViewId = (_this$state = this.state) === null || _this$state === void 0 ? void 0 : (_this$state$editorSet = _this$state.editorSettings) === null || _this$state$editorSet === void 0 ? void 0 : (_this$state$editorSet2 = _this$state$editorSet.kibanaSettings) === null || _this$state$editorSet2 === void 0 ? void 0 : _this$state$editorSet2.discoverIndexPatternId;
      const job = this.props.job;
      dataViews.get(dataViewId !== null && dataViewId !== void 0 ? dataViewId : '').catch(error => {
        // We still want to try to get the test URL as not all custom urls require a timefield to be passed.
        // eslint-disable-next-line no-console
        console.error('Error obtaining data view:', error);
      }).then(dataView => {
        var _dataView$timeFieldNa;
        const timefieldName = (_dataView$timeFieldNa = dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : null;
        (0, _utils.buildCustomUrlFromSettings)(dashboard, this.state.editorSettings).then(customUrl => {
          (0, _utils.getTestUrl)(job, customUrl, timefieldName, this.props.currentTimeFilter).then(testUrl => {
            (0, _custom_url_utils.openCustomUrlWindow)(testUrl, customUrl, basePath.get());
          }).catch(resp => {
            // eslint-disable-next-line no-console
            console.error('Error obtaining URL for test:', resp);
            toasts.addWarning(_i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.getTestUrlErrorNotificationMessage', {
              defaultMessage: 'An error occurred obtaining the URL to test the configuration'
            }));
          });
        });
      }).catch(resp => {
        // eslint-disable-next-line no-console
        console.error('Error building custom URL from settings:', resp);
        toasts.addWarning(_i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.buildUrlErrorNotificationMessage', {
          defaultMessage: 'An error occurred building the custom URL for testing from the supplied settings'
        }));
      });
    });
    (0, _defineProperty2.default)(this, "closeEditor", () => {
      this.setState({
        editorOpen: false
      });
    });
    this.state = {
      customUrls: [],
      dashboards: [],
      dataViewListItems: [],
      editorOpen: false,
      supportedFilterFields: []
    };
  }
  static getDerivedStateFromProps(props) {
    return {
      job: props.job,
      customUrls: props.jobCustomUrls
    };
  }
  componentDidMount() {
    const {
      toasts
    } = this.props.kibana.services.notifications;
    const {
      dashboardService
    } = this.props;
    dashboardService.fetchDashboards().then(dashboards => {
      this.setState({
        dashboards
      });
    }).catch(resp => {
      // eslint-disable-next-line no-console
      console.error('Error loading list of dashboards:', resp);
      toasts.addDanger(_i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.loadSavedDashboardsErrorNotificationMessage', {
        defaultMessage: 'An error occurred loading the list of saved Kibana dashboards'
      }));
    });
    (0, _edit_utils.loadDataViewListItems)().then(dataViewListItems => {
      this.setState({
        dataViewListItems
      });
    }).catch(resp => {
      // eslint-disable-next-line no-console
      console.error('Error loading list of dashboards:', resp);
      toasts.addDanger(_i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.loadDataViewsErrorNotificationMessage', {
        defaultMessage: 'An error occurred loading the list of saved data views'
      }));
    });
  }
  renderEditor() {
    var _this$props$editMode;
    const {
      customUrls,
      editorOpen,
      editorSettings,
      dashboards,
      dataViewListItems
    } = this.state;
    const editMode = (_this$props$editMode = this.props.editMode) !== null && _this$props$editMode !== void 0 ? _this$props$editMode : 'inline';
    const editor = /*#__PURE__*/_react.default.createElement(_custom_url_editor.CustomUrlEditor, {
      showCustomTimeRangeSelector: (0, _mlDataFrameAnalyticsUtils.isDataFrameAnalyticsConfigs)(this.props.job),
      customUrl: editorSettings,
      setEditCustomUrl: this.setEditCustomUrl,
      savedCustomUrls: customUrls,
      dashboards: dashboards,
      dataViewListItems: dataViewListItems,
      job: this.props.job
    });
    const isValidEditorSettings = editorOpen && editorSettings !== undefined ? (0, _utils.isValidCustomUrlSettings)(editorSettings, customUrls) : true;
    const addButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.addNewCustomUrl,
      isDisabled: !isValidEditorSettings,
      "data-test-subj": "mlJobAddCustomUrl"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.customUrls.addButtonLabel",
      defaultMessage: "Add"
    }));
    const testButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "popout",
      iconSide: "right",
      onClick: this.onTestButtonClick,
      isDisabled: !isValidEditorSettings
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.customUrls.testButtonLabel",
      defaultMessage: "Test"
    }));
    return editMode === 'inline' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      className: "edit-custom-url-panel"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      onClick: this.closeEditor,
      iconType: "cross",
      "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.closeEditorAriaLabel', {
        defaultMessage: 'Close custom URL editor'
      })
    }), editor, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, addButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, testButton))) : /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: this.closeEditor,
      initialFocus: "[name=label]",
      style: {
        width: 500
      },
      "data-test-subj": "mlJobNewCustomUrlFormModal"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.customUrls.addCustomUrlButtonLabel",
      defaultMessage: "Add custom URL"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, editor), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, testButton, addButton));
  }
  render() {
    const {
      customUrls,
      editorOpen
    } = this.state;
    const {
      editMode = 'inline'
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), (!editorOpen || editMode === 'modal') && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: this.editNewCustomUrl,
      "data-test-subj": "mlJobOpenCustomUrlFormButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.customUrls.addCustomUrlButtonLabel",
      defaultMessage: "Add custom URL"
    })), editorOpen && this.renderEditor(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_custom_url_editor.CustomUrlList, {
      job: this.props.job,
      customUrls: customUrls,
      onChange: this.props.setCustomUrls,
      dataViewListItems: this.state.dataViewListItems
    }));
  }
}
const CustomUrls = (0, _public.withKibana)(CustomUrlsUI);
exports.CustomUrls = CustomUrls;