"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMlGlobalServices = getMlGlobalServices;
exports.isServerless = isServerless;
exports.renderApp = void 0;
var _react = _interopRequireWildcard(require("react"));
require("./_index.scss");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _lodash = require("lodash");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _useLifecycles = _interopRequireDefault(require("react-use/lib/useLifecycles"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _license = require("../../common/license");
var _check_capabilities = require("./capabilities/check_capabilities");
var _storage = require("../../common/types/storage");
var _dependency_cache = require("./util/dependency_cache");
var _license2 = require("./license");
var _usage_collection = require("./services/usage_collection");
var _routing = require("./routing");
var _ml_api_service = require("./services/ml_api_service");
var _http_service = require("./services/http_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);

// temporary function to hardcode the serverless state
// this will be replaced by the true serverless information from kibana
function isServerless() {
  return false;
}

/**
 * Provides global services available across the entire ML app.
 */
function getMlGlobalServices(httpStart, usageCollection) {
  const httpService = new _http_service.HttpService(httpStart);
  const mlApiServices = (0, _ml_api_service.mlApiServicesProvider)(httpService);
  return {
    httpService,
    mlApiServices,
    mlUsageCollection: (0, _usage_collection.mlUsageCollectionProvider)(usageCollection),
    isServerless,
    mlCapabilities: new _check_capabilities.MlCapabilitiesService(mlApiServices),
    mlLicense: new _license.MlLicense()
  };
}
const App = ({
  coreStart,
  deps,
  appMountParams
}) => {
  var _deps$usageCollection, _deps$usageCollection2;
  const pageDeps = {
    history: appMountParams.history,
    setHeaderActionMenu: appMountParams.setHeaderActionMenu,
    setBreadcrumbs: coreStart.chrome.setBreadcrumbs
  };
  const services = (0, _react.useMemo)(() => {
    return {
      kibanaVersion: deps.kibanaVersion,
      share: deps.share,
      data: deps.data,
      security: deps.security,
      licenseManagement: deps.licenseManagement,
      storage: localStorage,
      embeddable: deps.embeddable,
      maps: deps.maps,
      triggersActionsUi: deps.triggersActionsUi,
      dataVisualizer: deps.dataVisualizer,
      usageCollection: deps.usageCollection,
      fieldFormats: deps.fieldFormats,
      dashboard: deps.dashboard,
      charts: deps.charts,
      cases: deps.cases,
      unifiedSearch: deps.unifiedSearch,
      licensing: deps.licensing,
      lens: deps.lens,
      savedObjectsManagement: deps.savedObjectsManagement,
      savedSearch: deps.savedSearch,
      ...coreStart,
      mlServices: getMlGlobalServices(coreStart.http, deps.usageCollection)
    };
  }, [deps, coreStart]);
  (0, _useLifecycles.default)(function setupLicenseOnMount() {
    (0, _license2.setLicenseCache)(services.mlServices.mlLicense);
    services.mlServices.mlLicense.setup(deps.licensing.license$);
  }, function destroyLicenseOnUnmount() {
    services.mlServices.mlLicense.unsubscribe();
  });

  // Wait for license and capabilities to be retrieved before rendering the app.
  const licenseReady = (0, _useObservable.default)(services.mlServices.mlLicense.isLicenseReady$, false);
  const mlCapabilities = (0, _useObservable.default)(services.mlServices.mlCapabilities.capabilities$, services.mlServices.mlCapabilities.getCapabilities());
  if (!licenseReady || !mlCapabilities) return null;
  const datePickerDeps = {
    ...(0, _lodash.pick)(services, ['data', 'http', 'notifications', 'theme', 'uiSettings']),
    toMountPoint: _public2.toMountPoint,
    wrapWithTheme: _public2.wrapWithTheme,
    uiSettingsKeys: _common.UI_SETTINGS
  };
  const I18nContext = coreStart.i18n.Context;
  const ApplicationUsageTrackingProvider = (_deps$usageCollection = (_deps$usageCollection2 = deps.usageCollection) === null || _deps$usageCollection2 === void 0 ? void 0 : _deps$usageCollection2.components.ApplicationUsageTrackingProvider) !== null && _deps$usageCollection !== void 0 ? _deps$usageCollection : _react.default.Fragment;
  return /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, null, /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
    theme$: appMountParams.theme$
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.ML_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_routing.MlRouter, {
    pageDeps: pageDeps
  })))))));
};
const renderApp = (coreStart, deps, appMountParams) => {
  (0, _dependency_cache.setDependencyCache)({
    timefilter: deps.data.query.timefilter,
    fieldFormats: deps.fieldFormats,
    autocomplete: deps.unifiedSearch.autocomplete,
    config: coreStart.uiSettings,
    chrome: coreStart.chrome,
    docLinks: coreStart.docLinks,
    toastNotifications: coreStart.notifications.toasts,
    overlays: coreStart.overlays,
    theme: coreStart.theme,
    recentlyAccessed: coreStart.chrome.recentlyAccessed,
    basePath: coreStart.http.basePath,
    savedSearch: deps.savedSearch,
    application: coreStart.application,
    http: coreStart.http,
    security: deps.security,
    dashboard: deps.dashboard,
    maps: deps.maps,
    dataVisualizer: deps.dataVisualizer,
    dataViews: deps.data.dataViews,
    share: deps.share,
    lens: deps.lens
  });
  appMountParams.onAppLeave(actions => actions.default());
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(App, {
    coreStart: coreStart,
    deps: deps,
    appMountParams: appMountParams
  }), appMountParams.element);
  return () => {
    (0, _dependency_cache.clearCache)();
    _reactDom.default.unmountComponentAtNode(appMountParams.element);
    deps.data.search.session.clear();
  };
};
exports.renderApp = renderApp;