"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _i18n = require("@kbn/i18n");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _job_selector = require("./job_selector");
var _kibana = require("../application/contexts/kibana");
var _jobs = require("../application/services/ml_api_service/jobs");
var _http_service = require("../application/services/http_service");
var _severity_control = require("../application/components/severity_control");
var _result_type_selector = require("./result_type_selector");
var _alerting = require("../application/services/ml_api_service/alerting");
var _preview_alert_condition = require("./preview_alert_condition");
var _interim_results_control = require("./interim_results_control");
var _config_validator = require("./config_validator");
var _advanced_settings = require("./advanced_settings");
var _alerts = require("../../common/util/alerts");
var _parse_interval = require("../../common/util/parse_interval");
var _beta_badge = require("./beta_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlAnomalyAlertTrigger = ({
  ruleParams,
  setRuleParams,
  setRuleProperty,
  errors,
  ruleInterval,
  alertNotifyWhen
}) => {
  const {
    services: {
      http
    },
    notifications: {
      toasts
    }
  } = (0, _kibana.useMlKibana)();
  const mlHttpService = (0, _react.useMemo)(() => new _http_service.HttpService(http), [http]);
  const adJobsApiService = (0, _react.useMemo)(() => (0, _jobs.jobsApiProvider)(mlHttpService), [mlHttpService]);
  const alertingApiService = (0, _react.useMemo)(() => (0, _alerting.alertingApiProvider)(mlHttpService), [mlHttpService]);
  const [jobConfigs, setJobConfigs] = (0, _react.useState)([]);
  const onAlertParamChange = (0, _react.useCallback)(param => update => {
    setRuleParams(param, update);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const jobsAndGroupIds = (0, _react.useMemo)(() => {
    var _ruleParams$jobSelect;
    return Object.values((_ruleParams$jobSelect = ruleParams.jobSelection) !== null && _ruleParams$jobSelect !== void 0 ? _ruleParams$jobSelect : {}).flat();
  }, [ruleParams.jobSelection]);

  /**
   * Extract alert related information based on the job selection
   */
  const fetchJobsConfig = (0, _react.useCallback)(async () => {
    try {
      const jobs = await adJobsApiService.jobs(jobsAndGroupIds);
      setJobConfigs(jobs);
    } catch (e) {
      toasts.danger({
        title: _i18n.i18n.translate('xpack.ml.anomalyDetectionAlert.errorFetchingJobs', {
          defaultMessage: 'Unable to fetch jobs configuration'
        }),
        body: e.message,
        toastLifeTimeMs: 5000
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobsAndGroupIds]);
  const availableResultTypes = (0, _react.useMemo)(() => {
    if (jobConfigs.length === 0) return Object.values(_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE);
    return (jobConfigs !== null && jobConfigs !== void 0 ? jobConfigs : []).some(v => {
      var _v$analysis_config, _v$analysis_config$in;
      return Boolean((_v$analysis_config = v.analysis_config) === null || _v$analysis_config === void 0 ? void 0 : (_v$analysis_config$in = _v$analysis_config.influencers) === null || _v$analysis_config$in === void 0 ? void 0 : _v$analysis_config$in.length);
    }) ? Object.values(_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE) : [_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET, _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.RECORD];
  }, [jobConfigs]);
  (0, _react.useEffect)(function checkJobsConfiguration() {
    if (jobsAndGroupIds.length === 0) return;
    fetchJobsConfig();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobsAndGroupIds]);
  (0, _useMount.default)(function setDefaults() {
    const {
      jobSelection,
      ...rest
    } = ruleParams;
    if (Object.keys(rest).length === 0) {
      setRuleProperty('params', {
        // Set defaults
        severity: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL,
        resultType: _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET,
        includeInterim: false,
        // Preserve job selection
        jobSelection,
        lookbackInterval: undefined,
        topNBuckets: undefined
      });
    }
  });
  const advancedSettings = (0, _react.useMemo)(() => {
    let {
      lookbackInterval,
      topNBuckets
    } = ruleParams;
    if (!(0, _mlIsDefined.isDefined)(lookbackInterval) && jobConfigs.length > 0) {
      lookbackInterval = (0, _alerts.getLookbackInterval)(jobConfigs);
    }
    if (!(0, _mlIsDefined.isDefined)(topNBuckets) && jobConfigs.length > 0) {
      topNBuckets = (0, _alerts.getTopNBuckets)(jobConfigs[0]);
    }
    return {
      lookbackInterval,
      topNBuckets
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ruleParams.lookbackInterval, ruleParams.topNBuckets, jobConfigs]);
  const resultParams = (0, _react.useMemo)(() => {
    return {
      ...ruleParams,
      ...advancedSettings
    };
  }, [ruleParams, advancedSettings]);
  const maxNumberOfBuckets = (0, _react.useMemo)(() => {
    if (jobConfigs.length === 0) return;
    const bucketDuration = (0, _parse_interval.parseInterval)(jobConfigs[0].analysis_config.bucket_span);
    const lookbackIntervalDuration = advancedSettings.lookbackInterval ? (0, _parse_interval.parseInterval)(advancedSettings.lookbackInterval) : null;
    if (lookbackIntervalDuration && bucketDuration) {
      return Math.ceil(lookbackIntervalDuration.asSeconds() / bucketDuration.asSeconds());
    }
  }, [jobConfigs, advancedSettings]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": 'mlAnomalyAlertForm'
  }, /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
    message: _i18n.i18n.translate('xpack.ml.anomalyDetectionAlert.betaBadgeTooltipContent', {
      defaultMessage: `Anomaly detection alerts are a beta feature. We'd love to hear your feedback.`
    })
  }), /*#__PURE__*/_react.default.createElement(_job_selector.JobSelectorControl, {
    jobsAndGroupIds: jobsAndGroupIds,
    adJobsApiService: adJobsApiService
    // eslint-disable-next-line react-hooks/exhaustive-deps
    ,
    onChange: (0, _react.useCallback)(onAlertParamChange('jobSelection'), []),
    errors: Array.isArray(errors.jobSelection) ? errors.jobSelection : []
  }), /*#__PURE__*/_react.default.createElement(_config_validator.ConfigValidator, {
    jobConfigs: jobConfigs,
    alertInterval: ruleInterval,
    alertNotifyWhen: alertNotifyWhen,
    alertParams: resultParams,
    maxNumberOfBuckets: maxNumberOfBuckets
  }), /*#__PURE__*/_react.default.createElement(_result_type_selector.ResultTypeSelector, {
    value: ruleParams.resultType,
    availableOption: availableResultTypes
    // eslint-disable-next-line react-hooks/exhaustive-deps
    ,
    onChange: (0, _react.useCallback)(onAlertParamChange('resultType'), [])
  }), /*#__PURE__*/_react.default.createElement(_severity_control.SeverityControl, {
    value: ruleParams.severity
    // eslint-disable-next-line react-hooks/exhaustive-deps
    ,
    onChange: (0, _react.useCallback)(onAlertParamChange('severity'), [])
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_interim_results_control.InterimResultsControl, {
    value: ruleParams.includeInterim
    // eslint-disable-next-line react-hooks/exhaustive-deps
    ,
    onChange: (0, _react.useCallback)(onAlertParamChange('includeInterim'), [])
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_advanced_settings.AdvancedSettings, {
    value: advancedSettings,
    onChange: (0, _react.useCallback)(update => {
      Object.keys(update).forEach(k => {
        setRuleParams(k, update[k]);
      });
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [])
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_preview_alert_condition.PreviewAlertCondition, {
    alertingApiService: alertingApiService,
    alertParams: ruleParams
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};

// Default export is required for React.lazy loading
//
// eslint-disable-next-line import/no-default-export
var _default = MlAnomalyAlertTrigger;
exports.default = _default;
module.exports = exports.default;