"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDataFrameAnalyticsConfigs = isDataFrameAnalyticsConfigs;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type guard for a DFA config
 *
 * @param {unknown} arg The config to identify
 * @returns {arg is DataFrameAnalyticsConfig}
 */
function isDataFrameAnalyticsConfigs(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['dest', 'analysis', 'id']) && typeof arg.id === 'string';
}

/**
 * Union type of DFA anlaysis config types
 */