"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isClassificationFeatureImportanceBaseline = isClassificationFeatureImportanceBaseline;
exports.isClassificationTotalFeatureImportance = isClassificationTotalFeatureImportance;
exports.isRegressionFeatureImportanceBaseline = isRegressionFeatureImportanceBaseline;
exports.isRegressionTotalFeatureImportance = isRegressionTotalFeatureImportance;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type guard for total feature importance
 *
 * @param {unknown} arg The feature importance to identify
 * @returns {arg is ClassificationTotalFeatureImportance}
 */
function isClassificationTotalFeatureImportance(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['classes']) && Array.isArray(arg.classes);
}

/**
 * Type guard for regression total feature importance
 *
 * @param {unknown} arg The feature importance to identify
 * @returns {arg is RegressionTotalFeatureImportance}
 */
function isRegressionTotalFeatureImportance(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['importance']);
}

/**
 * Type guard for classification feature importance baseline
 *
 * @param {unknown} arg The baseline to identify
 * @returns {arg is ClassificationFeatureImportanceBaseline}
 */
function isClassificationFeatureImportanceBaseline(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['classes']) && Array.isArray(arg.classes);
}

/**
 * Type guard for regression feature importance baseline
 *
 * @param {unknown} arg The baseline to identify
 * @returns {arg is RegressionFeatureImportanceBaseline}
 */
function isRegressionFeatureImportanceBaseline(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['baseline']);
}