"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeverityColor = getSeverityColor;
var _anomaly_threshold = require("./anomaly_threshold");
var _severity_colors = require("./severity_colors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a severity RGB color (one of critical, major, minor, warning, low or blank)
 * for the supplied normalized anomaly score (a value between 0 and 100).
 * @param normalizedScore - A normalized score between 0-100, which is based on the probability of the anomalousness of this record
 */
function getSeverityColor(normalizedScore) {
  if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL) {
    return _severity_colors.ML_SEVERITY_COLORS.CRITICAL;
  } else if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR) {
    return _severity_colors.ML_SEVERITY_COLORS.MAJOR;
  } else if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.MINOR) {
    return _severity_colors.ML_SEVERITY_COLORS.MINOR;
  } else if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.WARNING) {
    return _severity_colors.ML_SEVERITY_COLORS.WARNING;
  } else if (normalizedScore >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.LOW) {
    return _severity_colors.ML_SEVERITY_COLORS.LOW;
  } else {
    return _severity_colors.ML_SEVERITY_COLORS.BLANK;
  }
}