/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.maps_bundle_jsonpfunction=window.maps_bundle_jsonpfunction||[]).push([[3],{119:function(e,t,r){"use strict";r.d(t,"b",(function(){return L})),r.d(t,"a",(function(){return ems_file_source_EMSFileSource}));var s=r(4),a=r(1),i=r(70),o=r(2),n=r.n(o),l=r(14),c=r(132),d=r(3);class create_source_editor_EMSFileCreateSourceEditor extends s.Component{constructor(...e){super(...e),n()(this,"state",{emsFileId:null}),n()(this,"_onChange",(e=>{this.setState({emsFileId:e}),this.props.onSourceConfigChange({id:e})}))}render(){return Object(d.jsx)(l.EuiPanel,null,Object(d.jsx)(c.a,{value:this.state.emsFileId,onChange:this._onChange}))}}var u=r(147),p=r(0),h=r(73),g=r(72),m=r(40),b=r(135);class update_source_editor_UpdateSourceEditor extends s.Component{constructor(...e){super(...e),n()(this,"_isMounted",!1),n()(this,"state",{fields:null}),n()(this,"_onTooltipPropertiesSelect",(e=>{this.props.onChange({propName:"tooltipProperties",value:e})}))}componentDidMount(){this._isMounted=!0,this.loadFields()}componentWillUnmount(){this._isMounted=!1}async loadFields(){let e=[];try{const t=(await Object(h.getEmsFileLayers)()).find((e=>e.getId()===this.props.layerId));t&&(e=t.getFieldsInLanguage().map((e=>this.props.source.createField({fieldName:e.name}))))}catch(e){}this._isMounted&&this.setState({fields:e})}render(){return Object(d.jsx)(s.Fragment,null,Object(d.jsx)(l.EuiPanel,null,Object(d.jsx)(l.EuiTitle,{size:"xs"},Object(d.jsx)("h5",null,Object(d.jsx)(m.FormattedMessage,{id:"xpack.maps.emsSource.tooltipsTitle",defaultMessage:"Tooltip fields"}))),Object(d.jsx)(l.EuiSpacer,{size:"m"}),Object(d.jsx)(b.a,{tooltipFields:this.props.tooltipFields,onChange:this._onTooltipPropertiesSelect,fields:this.state.fields})),Object(d.jsx)(l.EuiSpacer,{size:"s"}))}}var y=r(143);class ems_file_field_EMSFileField extends y.a{constructor({fieldName:e,source:t,origin:r}){super({fieldName:e,origin:r}),n()(this,"_source",void 0),this._source=t}supportsFieldMetaFromEs(){return!1}supportsFieldMetaFromLocalData(){return!0}getSource(){return this._source}async getLabel(){return this._source.getEmsFieldLabel(this.getName())}}var _=r(5),S=r(98),j=r(19);function M(e){return a.i18n.translate("xpack.maps.source.emsFile.unableToFindFileIdErrorMessage",{defaultMessage:"Unable to find EMS vector shapes for id: {id}. {info}",values:{id:e,info:Object(S.a)()}})}function x(){return Object(_.l)().isEMSUrlSet()?a.i18n.translate("xpack.maps.source.emsOnPremFileTitle",{defaultMessage:"Elastic Maps Server Boundaries"}):a.i18n.translate("xpack.maps.source.emsFileTitle",{defaultMessage:"EMS Boundaries"})}class ems_file_source_EMSFileSource extends u.a{static createDescriptor({id:e,tooltipProperties:t=[]}){return{type:p.Bb.EMS_FILE,id:e,tooltipProperties:t}}constructor(e){super(ems_file_source_EMSFileSource.createDescriptor(e)),n()(this,"_tooltipFields",void 0),n()(this,"_descriptor",void 0),this._descriptor=ems_file_source_EMSFileSource.createDescriptor(e),this._tooltipFields=this._descriptor.tooltipProperties.map((e=>this.createField({fieldName:e})))}createField({fieldName:e}){return new ems_file_field_EMSFileField({fieldName:e,source:this,origin:p.E.SOURCE})}renderSourceSettingsEditor({onChange:e}){return Object(d.jsx)(update_source_editor_UpdateSourceEditor,{onChange:e,tooltipFields:this._tooltipFields,layerId:this._descriptor.id,source:this})}async getEMSFileLayer(){let e;try{e=await Object(h.getEmsFileLayers)()}catch(e){throw new Error(`${M(this._descriptor.id)} - ${e.message}`)}const t=e.find((e=>e.hasId(this._descriptor.id)));if(t)return t;throw new Error(M(this._descriptor.id))}async getEmsFieldLabel(e){const t=(await this.getEMSFileLayer()).getFieldsInLanguage().find((t=>t.name===e));return t?t.description:e}async getGeoJsonWithMeta(){try{const e=await this.getEMSFileLayer(),t=await e.getGeoJson();if(!t)throw new Error("No features found");const r=e.getFields().find((e=>"id"===e.type));return t.features.forEach(((e,t)=>{e.id=r?e.properties[r.id]:t})),{data:t,meta:{}}}catch(e){throw new Error(M(this._descriptor.id))}}async getImmutableProperties(){let e;try{e=(await this.getEMSFileLayer()).getEMSHotLink()}catch(e){}const t=[{label:Object(g.a)(),value:x()},{label:a.i18n.translate("xpack.maps.source.emsFile.layerLabel",{defaultMessage:"Layer"}),value:this._descriptor.id,link:e}],r=Object(_.l)();return r.isEMSUrlSet()&&t.push({label:a.i18n.translate("xpack.maps.source.emsFile.emsOnPremLabel",{defaultMessage:"Elastic Maps Server"}),value:r.getEMSRoot()}),t}async getDisplayName(){try{return(await this.getEMSFileLayer()).getDisplayName()}catch(e){return this._descriptor.id}}getAttributionProvider(){return async()=>(await this.getEMSFileLayer()).getAttributions()}async getLeftJoinFields(){return(await this.getEMSFileLayer()).getFieldsInLanguage().map((e=>this.createField({fieldName:e.name})))}hasTooltipProperties(){return this._tooltipFields.length>0}async getTooltipProperties(e){const t=this._tooltipFields.map((t=>{const r=e[t.getName()];return t.createTooltipProperty(r)}));return Promise.all(t)}async getSupportedShapeTypes(){return[p.Gb.POLYGON]}async getLicensedFeatures(){return Object(_.l)().isEMSUrlSet()?[j.a.ON_PREM_EMS]:[]}}const L={id:p.Ib.EMS_BOUNDARIES,order:10,categories:[p.bb.REFERENCE],checkVisibility:async()=>Object(_.l)().isIncludeElasticMapsService(),description:function(){const e=Object(_.l)();return a.i18n.translate("xpack.maps.source.emsFileSourceDescription",{defaultMessage:"Administrative boundaries from {host}",values:{host:e.isEMSUrlSet()?e.getEMSRoot():"Elastic Maps Service"}})}(),disabledReason:a.i18n.translate("xpack.maps.source.emsFileDisabledReason",{defaultMessage:"Elastic Maps Server requires an Enterprise license"}),getIsDisabled:()=>{const e=Object(_.l)();return e.isEMSUrlSet()&&!e.hasOnPremLicense()},icon:()=>Object(d.jsx)("svg",{xmlns:"http://www.w3.org/2000/svg",width:"49",height:"25",fill:"none",viewBox:"0 0 49 25",className:"mapLayersWizardIcon"},Object(d.jsx)("path",{className:"mapLayersWizardIcon__backgroundDarker",d:"M30.766 14.01l1.602-12.954-1.389.237c-.744.253-1.768.38-2.702.45a43.28 43.28 0 01-1.259.07l-.092.004c-.312.014-.57.026-.72.042a1.895 1.895 0 00-.558.168c-.156.07-.316.156-.47.238l-.057.03c-.356.191-.687.358-1.025.4l-1.308.339v5.863c0 .698.142 2.17 0 3.443l-.204 1.67h8.182zM20.871 2.748c-.656.039-1.247.282-2.06.4l-.702.102c-.583.086-1.16.172-1.693.238-.75.093-1.389.145-1.82.113-.592-.044-1.124.341-1.61.843-.453.467-.926 1.1-1.429 1.777l-.144.193c-1.132 1.517-2.452 3.218-4.22 4.101-.214.108-.346.313-.432.528-.087.22-.14.489-.172.78-.064.587-.047 1.325.007 2.083.071 1.01.211 2.102.32 2.956.054.42.1.783.128 1.05.08.78-.128 1.769-.37 2.653-.088.319-.178.616-.258.882-.03.1-.06.195-.086.285a9.67 9.67 0 00-.12.434 1.518 1.518 0 00-.054.334c0 .279.11.577.283.842.175.268.426.52.735.708l.067.04.079-.001c4.133-.068 10.22-.554 10.972-.638a.582.582 0 00.334-.17c.083-.08.157-.182.224-.293.134-.223.264-.524.388-.867.249-.69.495-1.6.72-2.52.162-.654.545-1.41.683-2.01l.784-2.796c.066-.379.198-1.13.272-1.705.146-1.148-.01-2.54.097-3.999.107-1.458.171-2.917.146-4.052a10.13 10.13 0 00-.112-1.438 2.469 2.469 0 00-.131-.495c-.053-.128-.276-.358-.276-.358h-.55zm10.931 12.621s-1.169-.652-1.548-.642c-.757.019-1.298-.026-2.352 0h-5.489l-2.863 8.915c.2.066 1.938.444 2.242.447.62.005 1.478-.08 2.393-.197.88-.113 1.824-.258 2.678-.389l.113-.017a49.753 49.753 0 012.166-.305c.347-.034.996-.024 1.858-.007l.127.003c.827.017 1.819.037 2.869.023 2.198-.029 4.694-.204 6.5-.887 1.42-.538 2.099-.87 2.513-1.34.414-.468.575-1.576.575-1.576s-2.907.868-4.807.784c-.927-.04-1.508.045-2.352-.34-1.429-.652-1.206-2.221-2.43-3.205-.77-.62-2.193-1.267-2.193-1.267z"}),Object(d.jsx)("path",{className:"mapLayersWizardIcon__backgroundDarker",d:"M33.322 1.125S31.277 14.3 31.72 14.522c.786.393 2.012.665 3.137 1.67 1.23 1.1 1.172 2.5 2.318 3.24.835.538 6.525-.704 6.525-.704l.228-7.956s-.174-4.5-.89-5.216c-.715-.716-2.488-1.125-3-2.08-1.115-2.08-3.068-2.351-3.068-2.351h-3.648z"})),renderWizard:({previewLayers:e,mapColors:t})=>Object(d.jsx)(create_source_editor_EMSFileCreateSourceEditor,{onSourceConfigChange:r=>{const s=ems_file_source_EMSFileSource.createDescriptor(r),a=i.b.createDescriptor({sourceDescriptor:s},t);e([a])}}),title:x()}},120:function(e,t,r){"use strict";r.d(t,"a",(function(){return heatmap_layer_HeatmapLayer}));var s=r(2),a=r.n(s),i=r(104),o=r(4),n=r.n(o),l=r(14),c=r(78),d=r(1);const u=d.i18n.translate("xpack.maps.heatmap.colorRampLabel",{defaultMessage:"Color range"});var p=r(3);function h({colorRampName:e,onHeatmapColorChange:t}){return Object(p.jsx)(l.EuiFormRow,{label:u,display:"rowCompressed"},Object(p.jsx)(l.EuiColorPalettePicker,{palettes:c.e,onChange:e=>{t({colorRampName:e})},valueOfSelected:e,compressed:!0}))}const g=({colorPaletteId:e})=>{const t=Object(c.f)(e);return t.length?Object(p.jsx)("div",{className:"mapColorGradient",style:{background:Object(c.h)(t)}}):null};var m=r(209),b=r(208);class heatmap_legend_HeatmapLegend extends o.Component{constructor(...e){super(...e),a()(this,"_isMounted",!1),a()(this,"state",{label:""})}componentDidUpdate(){this._loadLabel()}componentDidMount(){this._isMounted=!0,this._loadLabel()}componentWillUnmount(){this._isMounted=!1}async _loadLabel(){const e=await this.props.field.getLabel();this._isMounted&&this.state.label!==e&&this.setState({label:e})}render(){const e=Object(p.jsx)(m.a,{header:Object(p.jsx)(g,{colorPaletteId:this.props.colorRampName}),minLabel:d.i18n.translate("xpack.maps.heatmapLegend.coldLabel",{defaultMessage:"cold"}),maxLabel:d.i18n.translate("xpack.maps.heatmapLegend.hotLabel",{defaultMessage:"hot"}),propertyLabel:u,fieldLabel:this.state.label,invert:!1});let t;if("getMask"in this.props.field){const e=this.props.field.getMask();e&&(t=Object(p.jsx)(b.a,{esAggField:this.props.field,operator:e.operator,value:e.value}))}return t?Object(p.jsx)(n.a.Fragment,null,t,e):e}}var y=r(0);class heatmap_style_HeatmapStyle{constructor(e={colorRampName:c.c}){a()(this,"_descriptor",void 0),this._descriptor=heatmap_style_HeatmapStyle.createDescriptor(e.colorRampName)}static createDescriptor(e){return{type:y.Z.HEATMAP,colorRampName:e||c.c}}getType(){return y.Z.HEATMAP}renderEditor(e){return Object(p.jsx)(h,{colorRampName:this._descriptor.colorRampName,onHeatmapColorChange:({colorRampName:t})=>{const r=heatmap_style_HeatmapStyle.createDescriptor(t);e(r)}})}renderLegendDetails(e){return Object(p.jsx)(heatmap_legend_HeatmapLegend,{colorRampName:this._descriptor.colorRampName,field:e})}getIcon(){return Object(p.jsx)(l.EuiIcon,{size:"m",type:"heatmap"})}setMBPaintProperties({mbMap:e,layerId:t,propertyName:r,max:s,resolution:a}){let i;i=a===y.M.COARSE?128:a===y.M.FINE?64:a===y.M.MOST_FINE?32:8,e.setPaintProperty(t,"heatmap-radius",i),s<=0?e.setPaintProperty(t,"heatmap-weight",0):e.setPaintProperty(t,"heatmap-weight",["/",["get",r],s]);const o=Object(c.i)(this._descriptor.colorRampName,.1,1,!1);o&&e.setPaintProperty(t,"heatmap-color",["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",...o])}}var _=r(70),S=r(212),j=r(130),M=r(106);class heatmap_layer_HeatmapLayer extends i.a{static createDescriptor(e){const t=super.createDescriptor(e);return t.type=y.ab.HEATMAP,t.style=heatmap_style_HeatmapStyle.createDescriptor(),t}constructor({layerDescriptor:e,source:t}){if(super({layerDescriptor:e,source:t}),a()(this,"_style",void 0),e.style)this._style=new heatmap_style_HeatmapStyle(e.style);else{const e=heatmap_style_HeatmapStyle.createDescriptor();this._style=new heatmap_style_HeatmapStyle(e)}}_isTiled(){return!0}getLayerIcon(e){const{docCount:t}=Object(j.e)(this._getMetaFromTiles());return 0===t?_.d:super.getLayerIcon(e)}getSource(){return super.getSource()}getStyleForEditing(){return this._style}getStyle(){return this._style}getCurrentStyle(){return this._style}_getHeatmapLayerId(){return this.makeMbLayerId("heatmap")}getMbLayerIds(){return[this._getHeatmapLayerId()]}ownsMbLayerId(e){return this._getHeatmapLayerId()===e}ownsMbSourceId(e){return this.getId()===e}async syncData(e){await Object(_.g)({buffer:0,hasLabels:!1,layerId:this.getId(),layerName:await this.getDisplayName(),prevDataRequest:this.getSourceDataRequest(),requestMeta:Object(S.a)(this.getSource(),this.getSource().getFieldNames(),e.dataFilters,this.getQuery(),e.isForceRefresh,e.isFeatureEditorOpenForLayer),source:this.getSource(),syncContext:e})}_requiresPrevSourceCleanup(e){var t;const r=e.getSource(this.getMbSourceId());if(!r)return!1;const s=this.getSourceDataRequest();if(!s)return!1;const a=s.getData();return!!a&&(null===(t=r.tiles)||void 0===t?void 0:t[0])!==a.tileUrl}syncLayerWithMB(e){this._removeStaleMbSourcesAndLayers(e);const t=this.getSourceDataRequest(),r=t?t.getData():void 0;if(!r)return;const s=this.getMbSourceId();e.getSource(s)||e.addSource(s,{type:"vector",tiles:[r.tileUrl],minzoom:r.tileMinZoom,maxzoom:r.tileMaxZoom});const a=this._getHeatmapLayerId();e.getLayer(a)||e.addLayer({id:a,type:"heatmap",source:s,"source-layer":r.tileSourceLayer,paint:{}});const i=this.getSource().getMetricFields();if(!i.length)return;const o=i[0],n=this._requiresPrevSourceCleanup(e)?[]:this._getMetaFromTiles();let l=0;for(let e=0;e<n.length;e++){const t=o.pluckRangeFromTileMetaFeature(n[e]);t&&(l=Math.max(t.max,l))}this.getCurrentStyle().setMBPaintProperties({mbMap:e,layerId:a,propertyName:o.getMbFieldName(),max:l,resolution:this.getSource().getGridResolution()}),this.syncVisibilityWithMb(e,a),e.setPaintProperty(a,"heatmap-opacity",this.getAlpha());const c=o.getMask();if(c){const t=new M.d({esAggField:o,isGeometrySourceMvt:!0,...c});e.setFilter(a,t.getMatchUnmaskedExpression())}e.setLayerZoomRange(a,this.getMinZoom(),this.getMaxZoom())}getLayerTypeIconName(){return"heatmap"}async getFields(){return this.getSource().getFields()}async hasLegendDetails(){return!0}renderLegendDetails(){const e=this.getSource().getMetricFields();return this.getCurrentStyle().renderLegendDetails(e[0])}async getBounds(e){return await Object(_.f)({layerId:this.getId(),syncContext:e(this.getId()),source:this.getSource(),sourceQuery:this.getQuery()})}async isFilteredByGlobalTime(){return this.getSource().getApplyGlobalTime()&&await this.getSource().isTimeAware()}getIndexPatternIds(){return this.getSource().getIndexPatternIds()}getQueryableIndexPatternIds(){return this.getSource().getQueryableIndexPatternIds()}async getLicensedFeatures(){return await this.getSource().getLicensedFeatures()}}},132:function(e,t,r){"use strict";r.d(t,"a",(function(){return EMSFileSelect}));var s=r(2),a=r.n(s),i=r(4),o=r(14),n=r(1),l=r(73),c=r(98),d=r(3);class EMSFileSelect extends i.Component{constructor(...e){super(...e),a()(this,"_isMounted",!1),a()(this,"state",{hasLoadedOptions:!1,emsFileOptions:[]}),a()(this,"_loadFileOptions",(async()=>{let e=[];try{e=await Object(l.getEmsFileLayers)()}catch(e){this._isMounted&&this.setState({hasLoadedOptions:!0,emsFileOptions:[]})}const t=e.map((e=>({value:e.getId(),label:e.getDisplayName()})));this._isMounted&&this.setState({hasLoadedOptions:!0,emsFileOptions:t})})),a()(this,"_onChange",(e=>{0!==e.length&&this.props.onChange(e[0].value)}))}componentWillUnmount(){this._isMounted=!1}componentDidMount(){this._isMounted=!0,this._loadFileOptions()}_renderSelect(){if(!this.state.hasLoadedOptions)return Object(d.jsx)(o.EuiSelect,{isLoading:!0});const e=this.state.emsFileOptions.find((e=>e.value===this.props.value));return Object(d.jsx)(o.EuiComboBox,{placeholder:n.i18n.translate("xpack.maps.emsFileSelect.selectPlaceholder",{defaultMessage:"Select EMS boundaries"}),options:this.state.emsFileOptions,selectedOptions:e?[e]:[],onChange:this._onChange,isClearable:!1,singleSelection:!0,isDisabled:0===this.state.emsFileOptions.length,"data-test-subj":"emsFileSelect"})}render(){return Object(d.jsx)(o.EuiFormRow,{label:n.i18n.translate("xpack.maps.source.emsFileSelect.selectLabel",{defaultMessage:"EMS boundaries"}),helpText:0===this.state.emsFileOptions.length?Object(c.a)():null,display:this.props.isColumnCompressed?"columnCompressed":"row"},this._renderSelect())}}},134:function(e,t,r){"use strict";r.d(t,"b",(function(){return x})),r.d(t,"a",(function(){return g.a})),r.d(t,"c",(function(){return F}));var s=r(1),a=r(4),i=r(2),o=r.n(i),n=r(88),l=r(99),c=r(14),d=r(79),u=r(229),p=r(3);function h(e){return!Object(d.i)(e)}class create_source_editor_CreateSourceEditor extends a.Component{constructor(...e){super(...e),o()(this,"state",{indexPattern:null,geoField:"",requestType:this.props.requestType}),o()(this,"onIndexPatternSelect",(e=>{this.setState({indexPattern:e},(()=>{const t=Object(d.a)(e.fields);t[0]&&this._onGeoFieldSelect(t[0].name)}))})),o()(this,"_onGeoFieldSelect",(e=>{this.setState({geoField:e},this.previewLayer)})),o()(this,"_onRequestTypeSelect",(e=>{this.setState({requestType:e},this.previewLayer)})),o()(this,"previewLayer",(()=>{const{indexPattern:e,geoField:t,requestType:r}=this.state,s=e&&t?{indexPatternId:e.id,geoField:t,requestType:r}:null;this.props.onSourceConfigChange(s)}))}_renderGeoSelect(){return this.state.indexPattern?Object(p.jsx)(c.EuiFormRow,{label:s.i18n.translate("xpack.maps.source.esGeoGrid.geofieldLabel",{defaultMessage:"Cluster field"})},Object(p.jsx)(n.a,{placeholder:s.i18n.translate("xpack.maps.source.esGeoGrid.geofieldPlaceholder",{defaultMessage:"Select geo field"}),value:this.state.geoField,onChange:this._onGeoFieldSelect,fields:this.state.indexPattern?Object(d.b)(this.state.indexPattern.fields):void 0,isFieldDisabled:h,getFieldDisabledReason:d.d})):null}_renderRenderAsSelect(){return this.state.indexPattern?Object(p.jsx)(u.a,{renderAs:this.state.requestType,onChange:this._onRequestTypeSelect}):null}render(){return Object(p.jsx)(c.EuiPanel,null,Object(p.jsx)(l.a,{dataView:this.state.indexPattern,onChange:this.onIndexPatternSelect}),this._renderGeoSelect(),this._renderRenderAsSelect())}}var g=r(102),m=r(70),b=r(77),y=r(80),_=r(0),S=r(78),j=r(214);const M=_.M.FINE,x={id:_.Ib.CLUSTERS,order:10,categories:[_.bb.ELASTICSEARCH],description:s.i18n.translate("xpack.maps.source.esGridClustersDescription",{defaultMessage:"Group documents into grids and hexagons"}),icon:()=>Object(p.jsx)("svg",{xmlns:"http://www.w3.org/2000/svg",width:"49",height:"25",viewBox:"0 0 49 25",className:"mapLayersWizardIcon"},Object(p.jsx)("path",{fill:"#69707D",d:"M37.864 5.114v2.84l2.227 1.137 2.227-1.136V5.114l-2.227-1.137-2.227 1.137zM22.273 5.682h4.454v4.545h-4.454V5.682zM22.273 10.227v4.546h-4.455v-4.546h4.455zM31.182 14.773h-4.455v4.545h4.455v-4.545zM44.545 17.045v2.841l2.228 1.137L49 19.886v-2.84l-2.227-1.137-2.228 1.136zM37.864 15.91v-2.842l2.227-1.136 2.227 1.136v2.841l-2.227 1.136-2.227-1.136z"}),Object(p.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M11.693 3.41c.923 0 1.67-.764 1.67-1.705 0-.942-.747-1.705-1.67-1.705-.922 0-1.67.763-1.67 1.705 0 .94.748 1.704 1.67 1.704zM3.898 6.818c1.537 0 2.784-1.272 2.784-2.84 0-1.57-1.247-2.842-2.784-2.842-1.538 0-2.784 1.272-2.784 2.841 0 1.57 1.246 2.841 2.784 2.841zM9.466 13.068c1.23 0 2.227-1.017 2.227-2.272 0-1.256-.997-2.273-2.227-2.273S7.239 9.54 7.239 10.796c0 1.255.997 2.272 2.227 2.272zM2.227 18.182c1.23 0 2.228-1.018 2.228-2.273 0-1.255-.998-2.273-2.228-2.273C.997 13.636 0 14.654 0 15.91c0 1.255.997 2.273 2.227 2.273zM10.023 25c1.845 0 3.34-1.526 3.34-3.41 0-1.882-1.495-3.408-3.34-3.408-1.845 0-3.341 1.526-3.341 3.409 0 1.883 1.496 3.409 3.34 3.409zM17.818 5.682h4.455v4.545h-4.455V5.682zM26.727 10.227h4.455v4.546h-4.455v-4.546zM26.727 14.773v4.545h-4.454v-4.545h4.454zM40.09 17.046v2.84l2.228 1.137 2.227-1.137v-2.84l-2.227-1.137-2.227 1.136zM35.636 11.932V9.09l2.228-1.136L40.09 9.09v2.84l-2.227 1.137-2.228-1.136zM42.318 5.114v2.84l2.227 1.137 2.228-1.136V5.114l-2.228-1.137-2.227 1.137z"}),Object(p.jsx)("path",{fill:"#98A2B3",d:"M40.09 1.136v2.841l2.228 1.137 2.227-1.137v-2.84L42.318 0l-2.227 1.136zM26.727 1.136h-4.454v4.546h4.454v4.545h-4.454v4.546h-4.455v4.545h4.455v-4.545h4.454v-4.546h4.455V5.682h-4.455V1.136zM40.09 9.09v2.842l2.228 1.136 2.227-1.136V9.09l-2.227-1.136-2.227 1.136zM37.864 23.864v-2.841l2.227-1.137 2.227 1.137v2.84L40.091 25l-2.227-1.136z"}),Object(p.jsx)("path",{fill:"#D3DAE6",d:"M44.545 3.977v-2.84L46.773 0 49 1.136v2.841l-2.227 1.137-2.228-1.137zM42.318 13.068v2.841l2.227 1.136 2.228-1.136v-2.84l-2.228-1.137-2.227 1.136zM26.727 19.318h-4.454v4.546h4.454v-4.546zM42.318 21.023v2.84L44.545 25l2.228-1.136v-2.841l-2.228-1.137-2.227 1.137z"})),renderWizard:({previewLayers:e})=>Object(p.jsx)(create_source_editor_CreateSourceEditor,{requestType:_.ub.POINT,onSourceConfigChange:t=>{if(!t)return void e([]);const r=g.a.createDescriptor({...t,resolution:M}),s=Object(b.i)(),a=y.a.createDescriptor({[_.Hb.FILL_COLOR]:{type:_.Db.DYNAMIC,options:{...s[_.Hb.FILL_COLOR].options,field:{name:_.k,origin:_.E.SOURCE},color:S.e[0].value,type:_.j.ORDINAL}},[_.Hb.LINE_COLOR]:{type:_.Db.STATIC,options:{color:"#FFF"}},[_.Hb.LINE_WIDTH]:{type:_.Db.STATIC,options:{size:0}},[_.Hb.ICON_SIZE]:{type:_.Db.DYNAMIC,options:{...s[_.Hb.ICON_SIZE].options,...Object(j.a)(M),field:{name:_.k,origin:_.E.SOURCE}}},[_.Hb.LABEL_TEXT]:{type:_.Db.DYNAMIC,options:{...s[_.Hb.LABEL_TEXT].options,field:{name:_.k,origin:_.E.SOURCE}}}}),i=r.requestType===_.ub.HEX?m.c.createDescriptor({sourceDescriptor:r,style:a}):m.b.createDescriptor({sourceDescriptor:r,style:a});e([i])}}),title:g.b};var L=r(120);const F={id:_.Ib.HEATMAP,order:10,categories:[_.bb.ELASTICSEARCH],description:s.i18n.translate("xpack.maps.source.esGridHeatmapDescription",{defaultMessage:"Group documents in grids to show density"}),icon:()=>Object(p.jsx)("svg",{xmlns:"http://www.w3.org/2000/svg",width:"49",height:"25",fill:"none",viewBox:"0 0 49 25",className:"mapLayersWizardIcon"},Object(p.jsx)("path",{className:"mapLayersWizardIcon__background",fillRule:"evenodd",d:"M29.012 20.309a10.393 10.393 0 01-6.608 2.359c-1.134 0-2.225-.181-3.247-.515a8.322 8.322 0 11-6.005-14.747A10.433 10.433 0 0122.404 1.8c3.973 0 7.428 2.222 9.19 5.49a8.322 8.322 0 11-2.582 13.019z",clipRule:"evenodd",opacity:"0.8"}),Object(p.jsx)("circle",{cx:"35.741",cy:"14.778",r:"3.989",className:"mapLayersWizardIcon__highlight"}),Object(p.jsx)("path",{className:"mapLayersWizardIcon__highlight",fillRule:"evenodd",d:"M20.021 16.957c-1.199-.773-2.221-.518-3.224.826-.896 1.2-2.587 1.272-3.963.482-1.332-.764-1.843-2.084-1.403-3.62.447-1.558 1.517-2.379 3.084-2.365 1.676.015 1.886-.16 2.496-1.863.8-2.235 2.274-3.8 4.704-4.07 2.266-.252 4.174.556 5.41 2.574 1.323 2.158 1.17 4.623-.348 6.462-1.65 1.998-3.962 2.574-6.756 1.574z",clipRule:"evenodd"})),renderWizard:({previewLayers:e})=>Object(p.jsx)(create_source_editor_CreateSourceEditor,{requestType:_.ub.HEATMAP,onSourceConfigChange:t=>{if(!t)return void e([]);const r=L.a.createDescriptor({sourceDescriptor:g.a.createDescriptor({...t,resolution:_.M.SUPER_FINE})});e([r])}}),title:g.c}},161:function(e,t,r){"use strict";r.d(t,"a",(function(){return l}));var s=r(149),a=r.n(s),i=r(84),o=r(74),n=r(85);async function l(e,t){if(!e.length)return null;const r=e.map((async e=>await e.isFittable()?e.getBounds(t):null));let s;try{s=await Promise.all(r)}catch(e){return e instanceof n.b||console.warn("Unhandled getBounds error for layer. Only DataRequestAbortError should be surfaced",e),null}const l=[];for(let e=0;e<s.length;e++){const t=s[e];null!==t&&t.minLon!==1/0&&t.maxLon!==1/0&&t.minLat!==-1/0&&t.maxLat!==-1/0&&(l.push([t.minLon,t.minLat]),l.push([t.maxLon,t.maxLat]))}return l.length?Object(o.r)(a()(Object(i.multiPoint)(l))):null}},230:function(e,t,r){"use strict";r.d(t,"a",(function(){return x}));var s=r(4),a=r(1),i=r(77),o=r(70),n=r(232),l=r(80),c=r(0),d=r(78),u=r(2),p=r.n(u),h=r(39),g=r.n(h),m=r(88),b=r(5),y=r(40),_=r(14),S=r(79),j=r(72),M=r(3);class create_source_editor_CreateSourceEditor extends s.Component{constructor(...e){super(...e),p()(this,"state",{isLoadingIndexPattern:!1,indexPattern:void 0,indexPatternId:void 0,sourceGeoField:void 0,destGeoField:void 0,indexPatternHasMultipleGeoFields:!1}),p()(this,"onIndexPatternSelect",(e=>{this.setState({indexPatternId:e},this.loadIndexPattern.bind(null,e))})),p()(this,"loadIndexPattern",(e=>{this.setState({isLoadingIndexPattern:!0,indexPattern:void 0,sourceGeoField:void 0,destGeoField:void 0,indexPatternHasMultipleGeoFields:!1},this.debouncedLoad.bind(null,e))})),p()(this,"debouncedLoad",g.a.debounce((async e=>{if(!e||0===e.length)return;let t;try{t=await Object(b.u)().get(e)}catch(e){return}if(!this._isMounted)return;if(this.state.indexPatternId!==e)return;const r=Object(S.a)(t.fields);this.setState({isLoadingIndexPattern:!1,indexPattern:t,indexPatternHasMultipleGeoFields:r.length>=2})}),300)),p()(this,"_onSourceGeoSelect",(e=>{this.setState({sourceGeoField:e},this.previewLayer)})),p()(this,"_onDestGeoSelect",(e=>{this.setState({destGeoField:e},this.previewLayer)})),p()(this,"previewLayer",(()=>{const{indexPatternId:e,sourceGeoField:t,destGeoField:r}=this.state,s=e&&t&&r?{indexPatternId:e,sourceGeoField:t,destGeoField:r}:null;this.props.onSourceConfigChange(s)}))}componentWillUnmount(){this._isMounted=!1}componentDidMount(){this._isMounted=!0}_renderGeoSelects(){if(!this.state.indexPattern||!this.state.indexPatternHasMultipleGeoFields)return null;const e=this.state.indexPattern?Object(S.a)(this.state.indexPattern.fields):void 0;return Object(M.jsx)(s.Fragment,null,Object(M.jsx)(_.EuiFormRow,{label:a.i18n.translate("xpack.maps.source.pewPew.sourceGeoFieldLabel",{defaultMessage:"Source"})},Object(M.jsx)(m.a,{placeholder:a.i18n.translate("xpack.maps.source.pewPew.sourceGeoFieldPlaceholder",{defaultMessage:"Select source geo field"}),value:this.state.sourceGeoField,onChange:this._onSourceGeoSelect,fields:e})),Object(M.jsx)(_.EuiFormRow,{label:a.i18n.translate("xpack.maps.source.pewPew.destGeoFieldLabel",{defaultMessage:"Destination"})},Object(M.jsx)(m.a,{placeholder:a.i18n.translate("xpack.maps.source.pewPew.destGeoFieldPlaceholder",{defaultMessage:"Select destination geo field"}),value:this.state.destGeoField,onChange:this._onDestGeoSelect,fields:e})))}_renderIndexPatternSelect(){const e=Object(b.t)();return Object(M.jsx)(_.EuiFormRow,{label:Object(j.b)()},Object(M.jsx)(e,{indexPatternId:this.state.indexPatternId,onChange:this.onIndexPatternSelect,placeholder:Object(j.d)(),fieldTypes:[c.A.GEO_POINT]}))}render(){let e;return this.state.indexPattern&&!this.state.indexPatternHasMultipleGeoFields&&(e=Object(M.jsx)(_.EuiCallOut,{color:"warning"},Object(M.jsx)("p",null,Object(M.jsx)(y.FormattedMessage,{id:"xpack.maps.source.pewPew.noSourceAndDestDetails",defaultMessage:"Selected data view does not contain source and destination fields."})))),Object(M.jsx)(_.EuiPanel,null,e,this._renderIndexPatternSelect(),this._renderGeoSelects())}}const x={id:c.Ib.POINT_2_POINT,order:10,categories:[c.bb.ELASTICSEARCH],description:a.i18n.translate("xpack.maps.source.pewPewDescription",{defaultMessage:"Aggregated data paths between the source and destination"}),icon:()=>Object(M.jsx)("svg",{xmlns:"http://www.w3.org/2000/svg",width:"49",height:"25",fill:"none",viewBox:"0 0 49 25",className:"mapLayersWizardIcon"},Object(M.jsx)("circle",{cx:"38.311",cy:"12.889",r:"1.636",className:"mapLayersWizardIcon__highlight"}),Object(M.jsx)("circle",{cx:"10.85",cy:"15.12",r:"1.636",className:"mapLayersWizardIcon__highlight",transform:"rotate(-27.34 10.85 15.12)"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M10.746 14.918l12.499-3.892.162.521-12.499 3.892z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M10.746 14.918l12.499-3.892.162.521-12.499 3.892z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M10.746 14.918l12.499-3.892.162.521-12.499 3.892z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M10.746 14.918l12.499-3.892.162.521-12.499 3.892z"}),Object(M.jsx)("circle",{cx:"6.805",cy:"4.603",r:"1.636",className:"mapLayersWizardIcon__highlight",transform:"rotate(-23.178 6.805 4.603)"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M6.27 4.194l17.235 5.888-.176.516L6.094 4.71z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M6.27 4.194l17.235 5.888-.176.516L6.094 4.71z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M6.27 4.194l17.235 5.888-.176.516L6.094 4.71z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M6.27 4.194l17.235 5.888-.176.516L6.094 4.71z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M22.8 9.673l16.113 2.854-.095.538-16.113-2.855z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M22.8 9.673l16.113 2.854-.095.538-16.113-2.855z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M22.8 9.673l16.113 2.854-.095.538-16.113-2.855z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M22.8 9.673l16.113 2.854-.095.538-16.113-2.855z"}),Object(M.jsx)("circle",{cx:"19.542",cy:"22.262",r:"1.636",className:"mapLayersWizardIcon__highlight",transform:"rotate(8.84 19.542 22.262)"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M19.28 22.43l4.937-12.124.505.206-4.937 12.124z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M19.28 22.43l4.937-12.124.505.206-4.937 12.124z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M19.28 22.43l4.937-12.124.505.206-4.937 12.124z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M19.28 22.43l4.937-12.124.505.206-4.937 12.124z"}),Object(M.jsx)("circle",{cx:"42.691",cy:"3.795",r:"1.636",className:"mapLayersWizardIcon__highlight",transform:"rotate(-6.89 42.691 3.795)"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M42.715 3.993l-18.251 7.243-.202-.507 18.252-7.243z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M42.715 3.993l-18.251 7.243-.202-.507 18.252-7.243z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M42.715 3.993l-18.251 7.243-.202-.507 18.252-7.243z"}),Object(M.jsx)("path",{className:"mapLayersWizardIcon__highlight",d:"M42.715 3.993l-18.251 7.243-.202-.507 18.252-7.243z"}),Object(M.jsx)("circle",{cx:"24.578",cy:"11.109",r:"2.727",className:"mapLayersWizardIcon__highlight"})),renderWizard:({previewLayers:e})=>Object(M.jsx)(create_source_editor_CreateSourceEditor,{onSourceConfigChange:t=>{if(!t)return void e([]);const r=Object(i.i)(),s=o.b.createDescriptor({sourceDescriptor:n.a.createDescriptor(t),style:l.a.createDescriptor({[c.Hb.LINE_COLOR]:{type:c.Db.DYNAMIC,options:{...r[c.Hb.LINE_COLOR].options,field:{name:c.k,origin:c.E.SOURCE},color:d.e[0].value}},[c.Hb.LINE_WIDTH]:{type:c.Db.DYNAMIC,options:{...r[c.Hb.LINE_WIDTH].options,field:{name:c.k,origin:c.E.SOURCE}}}})});e([s])}}),title:n.b}},232:function(e,t,r){"use strict";r.d(t,"b",(function(){return P})),r.d(t,"a",(function(){return es_pew_pew_source_ESPewPewSource}));var s=r(2),a=r.n(s),i=r(4),o=r(149),n=r.n(o),l=r(84),c=r(44),d=r(47),u=r(1),p=r(14),h=r(40),g=r(24),m=r(167),b=r(5),y=r(3);class update_source_editor_UpdateSourceEditor extends i.Component{constructor(...e){super(...e),a()(this,"_isMounted",!1),a()(this,"state",{fields:[]}),a()(this,"_onMetricsChange",(e=>{this.props.onChange({propName:"metrics",value:e})}))}componentDidMount(){this._isMounted=!0,this._loadFields()}componentWillUnmount(){this._isMounted=!1}async _loadFields(){let e;try{e=await Object(b.u)().get(this.props.indexPatternId)}catch(e){return}this._isMounted&&this.setState({fields:e.fields.filter((e=>!g.indexPatterns.isNestedField(e)))})}render(){return Object(y.jsx)(i.Fragment,null,Object(y.jsx)(p.EuiPanel,null,Object(y.jsx)(p.EuiTitle,{size:"xs"},Object(y.jsx)("h6",null,Object(y.jsx)(h.FormattedMessage,{id:"xpack.maps.source.pewPew.metricsLabel",defaultMessage:"Metrics"}))),Object(y.jsx)(p.EuiSpacer,{size:"m"}),Object(y.jsx)(m.a,{allowMultipleMetrics:!0,bucketsName:this.props.bucketsName,isJoin:!1,fields:this.state.fields,metrics:this.props.metrics,onChange:this._onMetricsChange})),Object(y.jsx)(p.EuiSpacer,{size:"s"}))}}var _=r(0),S=r(72),j=r(39),M=r.n(j),x=r(74);const L=0,F=1,f=["key","sourceCentroid"];function O(e){const t=e.split(","),r=parseFloat(t[L]);return[parseFloat(t[F]),r]}var E=r(111),w=r(85),I=r(115),v=r(114);const P=u.i18n.translate("xpack.maps.source.pewPewTitle",{defaultMessage:"Point to point"});class es_pew_pew_source_ESPewPewSource extends E.a{static createDescriptor(e){const t=E.a.createDescriptor(e);if(!Object(v.a)(e.sourceGeoField))throw new Error("Cannot create ESPewPewSourceDescriptor, sourceGeoField is not provided");if(!Object(v.a)(e.destGeoField))throw new Error("Cannot create ESPewPewSourceDescriptor, destGeoField is not provided");return{...t,type:_.Bb.ES_PEW_PEW,sourceGeoField:e.sourceGeoField,destGeoField:e.destGeoField}}constructor(e){super(e),a()(this,"_descriptor",void 0),this._descriptor=e}getBucketsName(){return u.i18n.translate("xpack.maps.source.pewPew.bucketsName",{defaultMessage:"paths"})}renderSourceSettingsEditor({onChange:e}){return Object(y.jsx)(update_source_editor_UpdateSourceEditor,{bucketsName:this.getBucketsName(),indexPatternId:this.getIndexPatternId(),onChange:e,metrics:this._descriptor.metrics})}isFilterByMapBounds(){return!0}supportsJoins(){return!1}getSyncMeta(e){return{geogridPrecision:this.getGeoGridPrecision(e.zoom)}}isGeoGridPrecisionAware(){return!0}async getSupportedShapeTypes(){return[_.Gb.LINE]}async getImmutableProperties(){return[{label:Object(S.a)(),value:P},{label:Object(S.b)(),value:await this.getDisplayName()},{label:u.i18n.translate("xpack.maps.source.pewPew.sourceGeoFieldLabel",{defaultMessage:"Source"}),value:this._descriptor.sourceGeoField},{label:u.i18n.translate("xpack.maps.source.pewPew.destGeoFieldLabel",{defaultMessage:"Destination"}),value:this._descriptor.destGeoField}]}getGeoGridPrecision(e){const t=Math.ceil(e)+2;return Math.min(t,29)}async getGeoJsonWithMeta(e,t,r,s,a){const i=await this.getIndexPattern(),o=await this.makeSearchSource(t,0);o.setField("trackTotalHits",!1),o.setField("aggs",{destSplit:{terms:{script:{source:`doc['${this._descriptor.destGeoField}'].value.toString()`,lang:"painless"},order:{_count:"desc"},size:100},aggs:{sourceGrid:{geotile_grid:{field:this._descriptor.sourceGeoField,precision:this.getGeoGridPrecision(t.zoom),size:500},aggs:{sourceCentroid:{geo_centroid:{field:this._descriptor.sourceGeoField}},...this.getValueAggsDsl(i)}}}}}),o.setField("filter",[...o.getField("filter"),Object(c.buildExistsFilter)({name:this._descriptor.sourceGeoField,type:"geo_point"},i)]);const n=await this._runEsQuery({requestId:this.getId(),requestName:u.i18n.translate("xpack.maps.pewPew.requestName",{defaultMessage:"{layerName} paths request",values:{layerName:e}}),searchSource:o,registerCancelCallback:r,requestDescription:u.i18n.translate("xpack.maps.source.pewPew.inspectorDescription",{defaultMessage:"Get paths from data view: {dataViewName}, source: {sourceFieldName}, destination: {destFieldName}",values:{dataViewName:i.getName(),destFieldName:this._descriptor.destGeoField,sourceFieldName:this._descriptor.sourceGeoField}}),searchSessionId:t.searchSessionId,executionContext:Object(I.b)({description:"es_pew_pew_source:connections"},t.executionContext),requestsAdapter:a.requests}),{featureCollection:l}=function(e){const t=[],r=M.a.get(e,"aggregations.destSplit.buckets",[]);for(let e=0;e<r.length;e++){const s=r[e],a=O(s.key),i=M.a.get(s,"sourceGrid.buckets",[]);for(let e=0;e<i.length;e++){const r=i[e],s=r.sourceCentroid;t.push({type:"Feature",geometry:{type:"LineString",coordinates:[[s.location.lon,s.location.lat],a]},id:`${a.join()},${r.key}`,properties:Object(x.j)(r,f)})}}return{featureCollection:{type:"FeatureCollection",features:t}}}(n);return{data:l,meta:{areResultsTrimmed:!1}}}getGeoFieldName(){return this._descriptor.destGeoField}async getBoundsForFilters(e,t){const r=await this.makeSearchSource(e,0);r.setField("trackTotalHits",!1),r.setField("aggs",{destFitToBounds:{geo_bounds:{field:this._descriptor.destGeoField}},sourceFitToBounds:{geo_bounds:{field:this._descriptor.sourceGeoField}}});const s=[];try{var a,i;const o=new AbortController;t((()=>o.abort()));const{rawResponse:n}=await Object(d.lastValueFrom)(r.fetch$({abortSignal:o.signal,legacyHitsTotal:!1,executionContext:Object(I.b)({description:"es_pew_pew_source:bounds"},e.executionContext)})),l=(null===(a=n.aggregations)||void 0===a?void 0:a.destFitToBounds).bounds;l&&(s.push([l.top_left.lon,l.top_left.lat]),s.push([l.bottom_right.lon,l.bottom_right.lat]));const c=(null===(i=n.aggregations)||void 0===i?void 0:i.sourceFitToBounds).bounds;c&&(s.push([c.top_left.lon,c.top_left.lat]),s.push([c.bottom_right.lon,c.bottom_right.lat]))}catch(e){if("AbortError"===e.name)throw new w.b;return null}return 0===s.length?null:Object(x.r)(n()(Object(l.multiPoint)(s)))}hasTooltipProperties(){return!0}}},275:function(e,t,r){"use strict";var s=r(232);r.d(t,"a",(function(){return s.a})),r(230)},95:function(e,t,r){"use strict";r.d(t,"a",(function(){return b})),r.d(t,"c",(function(){return m})),r.d(t,"b",(function(){return layer_group_LayerGroup}));var s=r(2),a=r.n(s),i=r(39),o=r.n(i),n=r(1),l=r(53),c=(r(4),r(14)),d=r(41),u=r(0),p=r(86),h=r(161),g=r(3);function m(e){return e instanceof layer_group_LayerGroup}const b=n.i18n.translate("xpack.maps.layerGroup.defaultName",{defaultMessage:"Layer group"});class layer_group_LayerGroup{static createDescriptor(e){return{...e,type:u.ab.LAYER_GROUP,id:"string"==typeof e.id&&e.id.length?e.id:Object(d.v4)(),label:"string"==typeof e.label&&e.label.length?e.label:b,sourceDescriptor:null,visible:"boolean"!=typeof e.visible||e.visible}}constructor({layerDescriptor:e}){a()(this,"_descriptor",void 0),a()(this,"_children",[]),this._descriptor=layer_group_LayerGroup.createDescriptor(e)}setChildren(e){this._children=e}getChildren(){return[...this._children]}async _asyncSomeChildren(e){const t=this.getChildren().map((async t=>t[e]()));return(await Promise.all(t)).some((e=>e))}getDescriptor(){return this._descriptor}async cloneDescriptor(){const e=Object(p.b)(this._descriptor);e.id=Object(d.v4)();const t=await this.getDisplayName();e.label=`Clone of ${t}`;const r=await Object(l.asyncMap)(this.getChildren(),(async t=>(await t.cloneDescriptor()).map((t=>(t.parent===this.getId()&&(t.parent=e.id),t)))));return[...o.a.flatten(r),e]}makeMbLayerId(e){throw new Error("makeMbLayerId should not be called on LayerGroup, LayerGroup does not render to map")}isPreviewLayer(){return!!this._descriptor.__isPreviewLayer}supportsElasticsearchFilters(){return this.getChildren().some((e=>e.supportsElasticsearchFilters()))}async supportsFitToBounds(){return this._asyncSomeChildren("supportsFitToBounds")}async isFittable(){return this._asyncSomeChildren("isFittable")}isIncludeInFitToBounds(){return this.getChildren().some((e=>e.isIncludeInFitToBounds()))}async isFilteredByGlobalTime(){return this._asyncSomeChildren("isFilteredByGlobalTime")}async getDisplayName(e){return this.getLabel()}async getAttributions(){return[]}getStyleForEditing(){throw new Error("getStyleForEditing should not be called on LayerGroup, LayerGroup does not render to map")}getStyle(){throw new Error("getStyle should not be called on LayerGroup, LayerGroup does not render to map")}getCurrentStyle(){throw new Error("getCurrentStyle should not be called on LayerGroup, LayerGroup does not render to map")}getLabel(){return this._descriptor.label?this._descriptor.label:""}getLocale(){return null}getLayerIcon(e){return{icon:Object(g.jsx)(c.EuiIcon,{size:"m",type:"layers"}),tooltipContent:""}}async hasLegendDetails(){return this._children.length>0}renderLegendDetails(){return null}getId(){return this._descriptor.id}getSource(){throw new Error("getSource should not be called on LayerGroup, LayerGroup does not render to map")}getSourceForEditing(){throw new Error("getSourceForEditing should not be called on LayerGroup, LayerGroup does not render to map")}isVisible(){return!!this._descriptor.visible}showAtZoomLevel(e){return e>=this.getMinZoom()&&e<=this.getMaxZoom()}getMinZoom(){let e;return this._children.forEach((t=>{e=void 0!==e?Math.min(e,t.getMinZoom()):t.getMinZoom()})),void 0!==e?e:u.mb}getMaxZoom(){let e;return this._children.forEach((t=>{e=void 0!==e?Math.max(e,t.getMaxZoom()):t.getMaxZoom()})),void 0!==e?e:u.ib}getMinSourceZoom(){let e=u.mb;return this._children.forEach((t=>{e=Math.max(e,t.getMinSourceZoom())})),e}getMbSourceId(){throw new Error("getMbSourceId should not be called on LayerGroup, LayerGroup does not render to map")}getAlpha(){throw new Error("getAlpha should not be called on LayerGroup, LayerGroup does not render to map")}getQuery(){return null}renderSourceSettingsEditor(e){return null}getPrevRequestToken(e){}getInFlightRequestTokens(){return[]}getSourceDataRequest(){}getDataRequest(e){}isLayerLoading(e){return this._children.some((t=>t.isLayerLoading(e)))}hasErrors(){return this._children.some((e=>e.hasErrors()))}getErrors(){const e=this._children.find((e=>e.hasErrors()));return e?e.getErrors():""}async syncData(e){}getMbLayerIds(){return[]}ownsMbLayerId(e){return!1}ownsMbSourceId(e){return!1}syncLayerWithMB(e){}getLayerTypeIconName(){return"layers"}async getBounds(e){return Object(h.a)(this.getChildren(),e)}renderStyleEditor(e,t){return null}getIndexPatternIds(){return[]}getQueryableIndexPatternIds(){return[]}syncVisibilityWithMb(e,t){throw new Error("syncVisibilityWithMb should not be called on LayerGroup, LayerGroup does not render to map")}getType(){return u.ab.LAYER_GROUP}areLabelsOnTop(){return!1}supportsLabelsOnTop(){return!1}supportsLabelLocales(){return!1}async getLicensedFeatures(){return[]}getGeoFieldNames(){return[]}async getStyleMetaDescriptorFromLocalFeatures(){throw new Error("getStyleMetaDescriptorFromLocalFeatures should not be called on LayerGroup, LayerGroup does not render to map")}isBasemap(e){return!1}getParent(){return this._descriptor.parent}}}}]);