"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapsStorage = void 0;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _content_management = require("../../common/content_management");
var _cm_services = require("../../common/content_management/cm_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchArgsToSOFindOptions = args => {
  const {
    query,
    contentTypeId,
    options
  } = args;
  return {
    type: contentTypeId,
    searchFields: options !== null && options !== void 0 && options.onlyTitle ? ['title'] : ['title^3', 'description'],
    fields: ['description', 'title'],
    search: query.text,
    perPage: query.limit,
    page: query.cursor ? +query.cursor : undefined,
    defaultSearchOperator: 'AND',
    ...(0, _contentManagementUtils.tagsToFindOptions)(query.tags)
  };
};
class MapsStorage extends _contentManagementUtils.SOContentStorage {
  constructor() {
    super({
      savedObjectType: _content_management.CONTENT_ID,
      cmServicesDefinition: _cm_services.cmServicesDefinition,
      searchArgsToSOFindOptions,
      enableMSearch: true,
      allowedSavedObjectAttributes: ['title', 'description', 'mapStateJSON', 'layerListJSON', 'uiStateJSON']
    });
  }
}
exports.MapsStorage = MapsStorage;