"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openModal = openModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _map_embeddables_singleton = require("../../embeddable/map_embeddables_singleton");
var _kibana_services = require("../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function openModal(title) {
  const {
    openModal: reactOverlaysOpenModal
  } = (0, _public.createReactOverlays)((0, _kibana_services.getCore)());
  const modalSession = reactOverlaysOpenModal( /*#__PURE__*/_react.default.createElement(FilterByMapExtentModal, {
    onClose: () => modalSession.close(),
    title: title
  }));
}
class FilterByMapExtentModal extends _react.Component {
  _renderSwitches() {
    return _map_embeddables_singleton.mapEmbeddablesSingleton.getMapPanels().map(mapPanel => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "columnCompressedSwitch",
        key: mapPanel.id
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: mapPanel.getTitle(),
        checked: mapPanel.getIsFilterByMapExtent(),
        onChange: event => {
          const isChecked = event.target.checked;
          mapPanel.setIsFilterByMapExtent(isChecked);

          // only a single map can create map bound filter at a time
          // disable all other map panels from creating map bound filter
          if (isChecked) {
            _map_embeddables_singleton.mapEmbeddablesSingleton.getMapPanels().forEach(it => {
              if (it.id !== mapPanel.id && it.getIsFilterByMapExtent()) {
                it.setIsFilterByMapExtent(false);
              }
            });
          }
          this.forceUpdate();
        },
        compressed: true,
        "data-test-subj": `filterByMapExtentSwitch${mapPanel.id}`
      }));
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, this.props.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, this._renderSwitches()));
  }
}