"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapsListView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _contentManagementTableListView = require("@kbn/content-management-table-list-view");
var _constants = require("../../../common/constants");
var _kibana_services = require("../../kibana_services");
var _content_management = require("../../content_management");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SAVED_OBJECTS_LIMIT_SETTING = 'savedObjects:listingLimit';
const SAVED_OBJECTS_PER_PAGE_SETTING = 'savedObjects:perPage';
function navigateToNewMap() {
  var _getUsageCollection;
  const navigateToApp = (0, _kibana_services.getNavigateToApp)();
  (_getUsageCollection = (0, _kibana_services.getUsageCollection)()) === null || _getUsageCollection === void 0 ? void 0 : _getUsageCollection.reportUiCounter(_constants.APP_ID, _analytics.METRIC_TYPE.CLICK, 'create_maps_vis_editor');
  navigateToApp(_constants.APP_ID, {
    path: _constants.MAP_PATH
  });
}
const toTableListViewSavedObject = mapItem => {
  var _mapItem$attributes$t;
  return {
    ...mapItem,
    updatedAt: mapItem.updatedAt,
    attributes: {
      ...mapItem.attributes,
      title: (_mapItem$attributes$t = mapItem.attributes.title) !== null && _mapItem$attributes$t !== void 0 ? _mapItem$attributes$t : ''
    }
  };
};
async function deleteMaps(items) {
  await Promise.all(items.map(({
    id
  }) => _content_management.mapsClient.delete(id)));
}
function MapsListViewComp({
  history
}) {
  (0, _kibana_services.getExecutionContextService)().set({
    type: 'application',
    name: _constants.APP_ID,
    page: 'list'
  });
  const isReadOnly = !(0, _kibana_services.getMapsCapabilities)().save;
  const listingLimit = (0, _kibana_services.getUiSettings)().get(SAVED_OBJECTS_LIMIT_SETTING);
  const initialPageSize = (0, _kibana_services.getUiSettings)().get(SAVED_OBJECTS_PER_PAGE_SETTING);

  // TLDR; render should be side effect free
  //
  // setBreadcrumbs fires observables which cause state changes in ScreenReaderRouteAnnouncements.
  // wrap chrome updates in useEffect to avoid potentially causing state changes in other component during render phase.
  (0, _react.useEffect)(() => {
    (0, _kibana_services.getCoreChrome)().docTitle.change(_constants.APP_NAME);
    (0, _kibana_services.getCoreChrome)().setBreadcrumbs([{
      text: _constants.APP_NAME
    }]);
  }, []);
  const findMaps = (0, _react.useCallback)(async (searchTerm, {
    references = [],
    referencesToExclude = []
  } = {}) => {
    return _content_management.mapsClient.search({
      text: searchTerm ? `${searchTerm}*` : undefined,
      limit: (0, _kibana_services.getUiSettings)().get(SAVED_OBJECTS_LIMIT_SETTING),
      tags: {
        included: references.map(({
          id
        }) => id),
        excluded: referencesToExclude.map(({
          id
        }) => id)
      }
    }).then(({
      hits,
      pagination: {
        total
      }
    }) => {
      return {
        total,
        hits: hits.map(toTableListViewSavedObject)
      };
    }).catch(e => {
      return {
        total: 0,
        hits: []
      };
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_contentManagementTableListView.TableListView, {
    id: "map",
    headingId: "mapsListingPage",
    createItem: isReadOnly ? undefined : navigateToNewMap,
    findItems: findMaps,
    deleteItems: isReadOnly ? undefined : deleteMaps,
    listingLimit: listingLimit,
    initialFilter: '',
    initialPageSize: initialPageSize,
    entityName: _i18n.i18n.translate('xpack.maps.mapListing.entityName', {
      defaultMessage: 'map'
    }),
    entityNamePlural: _i18n.i18n.translate('xpack.maps.mapListing.entityNamePlural', {
      defaultMessage: 'maps'
    }),
    title: _constants.APP_NAME,
    onClickTitle: ({
      id
    }) => history.push((0, _constants.getEditPath)(id))
  });
}
const MapsListView = /*#__PURE__*/(0, _react.memo)(MapsListViewComp);
exports.MapsListView = MapsListView;