"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultMapSettings = getDefaultMapSettings;
var _uiTheme = require("@kbn/ui-theme");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultMapSettings() {
  return {
    autoFitToDataBounds: false,
    backgroundColor: _uiTheme.euiThemeVars.euiColorEmptyShade,
    customIcons: [],
    disableInteractive: false,
    disableTooltipControl: false,
    hideToolbarOverlay: false,
    hideLayerControl: false,
    hideViewControl: false,
    initialLocation: _constants.INITIAL_LOCATION.LAST_SAVED_LOCATION,
    fixedLocation: {
      lat: 0,
      lon: 0,
      zoom: 2
    },
    browserLocation: {
      zoom: 2
    },
    keydownScrollZoom: false,
    maxZoom: _constants.MAX_ZOOM,
    minZoom: _constants.MIN_ZOOM,
    showScaleControl: false,
    showSpatialFilters: true,
    showTimesliderToggleButton: true,
    spatialFiltersAlpa: 0.3,
    spatialFiltersFillColor: '#DA8B45',
    spatialFiltersLineColor: '#DA8B45'
  };
}