"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _public3 = require("@kbn/embeddable-plugin/public");
var _legacy_visualizations = require("./legacy_visualizations");
var _locator_definition = require("./locators/map_locator/locator_definition");
var _locator_definition2 = require("./locators/tile_map_locator/locator_definition");
var _locator_definition3 = require("./locators/region_map_locator/locator_definition");
var _licensed_features = require("./licensed_features");
var _source_registry = require("./classes/sources/source_registry");
var _layer_wizard_registry = require("./classes/layers/wizards/layer_wizard_registry");
var _api = require("./api");
var _map_embeddable_factory = require("./embeddable/map_embeddable_factory");
var _action = require("./trigger_actions/filter_by_map_extent/action");
var _action2 = require("./trigger_actions/synchronize_movement/action");
var _visualize_geo_field_action = require("./trigger_actions/visualize_geo_field_action");
var _constants = require("../common/constants");
var _maps_vis_type_alias = require("./maps_vis_type_alias");
var _feature_catalogue_entry = require("./feature_catalogue_entry");
var _kibana_services = require("./kibana_services");
var _map_inspector_view = require("./inspector/map_adapter/map_inspector_view");
var _vector_tile_inspector_view = require("./inspector/vector_tile_adapter/vector_tile_inspector_view");
var _lens = require("./lens");
var _content_management = require("../common/content_management");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/** @internal */
class MapsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "_initializerContext", void 0);
    this._initializerContext = initializerContext;
  }
  setup(core, plugins) {
    var _plugins$screenshotMo, _plugins$cloud;
    (0, _licensed_features.registerLicensedFeatures)(plugins.licensing);
    const config = this._initializerContext.config.get();
    (0, _kibana_services.setMapAppConfig)({
      ...config,
      // Override this when we know we are taking a screenshot (i.e. no user interaction)
      // to avoid a blank-canvas issue when rendering maps on a PDF
      preserveDrawingBuffer: (_plugins$screenshotMo = plugins.screenshotMode) !== null && _plugins$screenshotMo !== void 0 && _plugins$screenshotMo.isScreenshotMode() ? true : config.preserveDrawingBuffer
    });
    const locator = plugins.share.url.locators.create(new _locator_definition.MapsAppLocatorDefinition({
      useHash: core.uiSettings.get('state:storeInSessionStorage')
    }));
    plugins.share.url.locators.create(new _locator_definition2.MapsAppTileMapLocatorDefinition({
      locator
    }));
    plugins.share.url.locators.create(new _locator_definition3.MapsAppRegionMapLocatorDefinition({
      locator
    }));
    plugins.inspector.registerView(_vector_tile_inspector_view.VectorTileInspectorView);
    plugins.inspector.registerView(_map_inspector_view.MapInspectorView);
    if (plugins.home) {
      plugins.home.featureCatalogue.register(_feature_catalogue_entry.featureCatalogueEntry);
    }
    plugins.visualizations.registerAlias((0, _maps_vis_type_alias.getMapsVisTypeAlias)());
    plugins.embeddable.registerEmbeddableFactory(_constants.MAP_SAVED_OBJECT_TYPE, new _map_embeddable_factory.MapEmbeddableFactory());
    core.application.register({
      id: _constants.APP_ID,
      title: _constants.APP_NAME,
      order: 4000,
      icon: `plugins/${_constants.APP_ID}/icon.svg`,
      euiIconType: _constants.APP_ICON_SOLUTION,
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      async mount(params) {
        var _plugins$usageCollect, _plugins$usageCollect2;
        const [coreStart, {
          savedObjectsTagging
        }] = await core.getStartServices();
        const UsageTracker = (_plugins$usageCollect = (_plugins$usageCollect2 = plugins.usageCollection) === null || _plugins$usageCollect2 === void 0 ? void 0 : _plugins$usageCollect2.components.ApplicationUsageTrackingProvider) !== null && _plugins$usageCollect !== void 0 ? _plugins$usageCollect : _react.default.Fragment;
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./render_app')));
        return renderApp(params, {
          coreStart,
          AppUsageTracker: UsageTracker,
          savedObjectsTagging
        });
      }
    });
    plugins.contentManagement.registry.register({
      id: _content_management.CONTENT_ID,
      version: {
        latest: _content_management.LATEST_VERSION
      },
      name: _constants.APP_NAME
    });
    (0, _lens.setupLensChoroplethChart)(core, plugins.expressions, plugins.lens);

    // register wrapper around legacy tile_map and region_map visualizations
    plugins.data.search.aggs.types.registerLegacy(_legacy_visualizations.GEOHASH_GRID, _legacy_visualizations.getGeoHashBucketAgg);
    plugins.expressions.registerFunction(_legacy_visualizations.createRegionMapFn);
    plugins.expressions.registerRenderer(_legacy_visualizations.regionMapRenderer);
    plugins.visualizations.createBaseVisualization(_legacy_visualizations.regionMapVisType);
    plugins.expressions.registerFunction(_legacy_visualizations.createTileMapFn);
    plugins.expressions.registerRenderer(_legacy_visualizations.tileMapRenderer);
    plugins.visualizations.createBaseVisualization(_legacy_visualizations.tileMapVisType);
    (0, _kibana_services.setIsCloudEnabled)(!!((_plugins$cloud = plugins.cloud) !== null && _plugins$cloud !== void 0 && _plugins$cloud.isCloudEnabled));
    return {
      registerLayerWizard: _layer_wizard_registry.registerLayerWizardExternal,
      registerSource: _source_registry.registerSource
    };
  }
  start(core, plugins) {
    (0, _licensed_features.setLicensingPluginStart)(plugins.licensing);
    (0, _kibana_services.setStartServices)(core, plugins);
    if (core.application.capabilities.maps.show) {
      plugins.uiActions.addTriggerAction(_public2.VISUALIZE_GEO_FIELD_TRIGGER, _visualize_geo_field_action.visualizeGeoFieldAction);
    }
    plugins.uiActions.addTriggerAction(_public3.CONTEXT_MENU_TRIGGER, _action.filterByMapExtentAction);
    plugins.uiActions.addTriggerAction(_public3.CONTEXT_MENU_TRIGGER, _action2.synchronizeMovementAction);
    if (!core.application.capabilities.maps.save) {
      plugins.visualizations.unRegisterAlias(_constants.APP_ID);
    }
    return {
      createLayerDescriptors: _api.createLayerDescriptors,
      suggestEMSTermJoinConfig: _api.suggestEMSTermJoinConfig
    };
  }
}
exports.MapsPlugin = MapsPlugin;