"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _map_component = require("../../embeddable/map_component");
var _create_tile_map_layer_descriptor = require("../../classes/layers/create_tile_map_layer_descriptor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TileMapVisualization(props) {
  const mapCenter = {
    lat: props.visConfig.mapCenter[0],
    lon: props.visConfig.mapCenter[1],
    zoom: props.visConfig.mapZoom
  };
  function getLayerDescriptors() {
    const layerDescriptor = (0, _create_tile_map_layer_descriptor.createTileMapLayerDescriptor)(props.visConfig.layerDescriptorParams);
    return layerDescriptor ? [layerDescriptor] : [];
  }
  return /*#__PURE__*/_react.default.createElement(_map_component.MapComponent, {
    title: props.visConfig.layerDescriptorParams.label,
    filters: props.filters,
    query: props.query,
    timeRange: props.timeRange,
    mapCenter: mapCenter,
    getLayerDescriptors: getLayerDescriptors,
    onInitialRenderComplete: props.onInitialRenderComplete,
    isSharable: false
  });
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
var _default = TileMapVisualization;
exports.default = _default;
module.exports = exports.default;